// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicediscovery

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DiscoverInstancesInput struct {
	_ struct{} `type:"structure"`

	// The health status of the instances that you want to discover.
	HealthStatus HealthStatusFilter `type:"string" enum:"true"`

	// The maximum number of instances that you want AWS Cloud Map to return in
	// the response to a DiscoverInstances request. If you don't specify a value
	// for MaxResults, AWS Cloud Map returns up to 100 instances.
	MaxResults *int64 `min:"1" type:"integer"`

	// The name of the namespace that you specified when you registered the instance.
	//
	// NamespaceName is a required field
	NamespaceName *string `type:"string" required:"true"`

	// A string map that contains attributes with values that you can use to filter
	// instances by any custom attribute that you specified when you registered
	// the instance. Only instances that match all the specified key/value pairs
	// will be returned.
	QueryParameters map[string]string `type:"map"`

	// The name of the service that you specified when you registered the instance.
	//
	// ServiceName is a required field
	ServiceName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DiscoverInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DiscoverInstancesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DiscoverInstancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.NamespaceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("NamespaceName"))
	}

	if s.ServiceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DiscoverInstancesOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains one HttpInstanceSummary for each registered
	// instance.
	Instances []HttpInstanceSummary `type:"list"`
}

// String returns the string representation
func (s DiscoverInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDiscoverInstances = "DiscoverInstances"

// DiscoverInstancesRequest returns a request value for making API operation for
// AWS Cloud Map.
//
// Discovers registered instances for a specified namespace and service. You
// can use DiscoverInstances to discover instances for any type of namespace.
// For public and private DNS namespaces, you can also use DNS queries to discover
// instances.
//
//    // Example sending a request using DiscoverInstancesRequest.
//    req := client.DiscoverInstancesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DiscoverInstances
func (c *Client) DiscoverInstancesRequest(input *DiscoverInstancesInput) DiscoverInstancesRequest {
	op := &aws.Operation{
		Name:       opDiscoverInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DiscoverInstancesInput{}
	}

	req := c.newRequest(op, input, &DiscoverInstancesOutput{})
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("data-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return DiscoverInstancesRequest{Request: req, Input: input, Copy: c.DiscoverInstancesRequest}
}

// DiscoverInstancesRequest is the request type for the
// DiscoverInstances API operation.
type DiscoverInstancesRequest struct {
	*aws.Request
	Input *DiscoverInstancesInput
	Copy  func(*DiscoverInstancesInput) DiscoverInstancesRequest
}

// Send marshals and sends the DiscoverInstances API request.
func (r DiscoverInstancesRequest) Send(ctx context.Context) (*DiscoverInstancesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DiscoverInstancesResponse{
		DiscoverInstancesOutput: r.Request.Data.(*DiscoverInstancesOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DiscoverInstancesResponse is the response type for the
// DiscoverInstances API operation.
type DiscoverInstancesResponse struct {
	*DiscoverInstancesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DiscoverInstances request.
func (r *DiscoverInstancesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
