// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicediscovery

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListOperationsInput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains specifications for the operations that you want
	// to list, for example, operations that you started between a specified start
	// date and end date.
	//
	// If you specify more than one filter, an operation must match all filters
	// to be returned by ListOperations.
	Filters []OperationFilter `type:"list"`

	// The maximum number of items that you want AWS Cloud Map to return in the
	// response to a ListOperations request. If you don't specify a value for MaxResults,
	// AWS Cloud Map returns up to 100 operations.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListOperations request, omit this value.
	//
	// If the response contains NextToken, submit another ListOperations request
	// to get the next group of results. Specify the value of NextToken from the
	// previous response in the next request.
	//
	// AWS Cloud Map gets MaxResults operations and then filters them based on the
	// specified criteria. It's possible that no operations in the first MaxResults
	// operations matched the specified criteria but that subsequent groups of MaxResults
	// operations do contain operations that match the criteria.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListOperationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOperationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListOperationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListOperationsOutput struct {
	_ struct{} `type:"structure"`

	// If the response contains NextToken, submit another ListOperations request
	// to get the next group of results. Specify the value of NextToken from the
	// previous response in the next request.
	//
	// AWS Cloud Map gets MaxResults operations and then filters them based on the
	// specified criteria. It's possible that no operations in the first MaxResults
	// operations matched the specified criteria but that subsequent groups of MaxResults
	// operations do contain operations that match the criteria.
	NextToken *string `type:"string"`

	// Summary information about the operations that match the specified criteria.
	Operations []OperationSummary `type:"list"`
}

// String returns the string representation
func (s ListOperationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListOperations = "ListOperations"

// ListOperationsRequest returns a request value for making API operation for
// AWS Cloud Map.
//
// Lists operations that match the criteria that you specify.
//
//    // Example sending a request using ListOperationsRequest.
//    req := client.ListOperationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListOperations
func (c *Client) ListOperationsRequest(input *ListOperationsInput) ListOperationsRequest {
	op := &aws.Operation{
		Name:       opListOperations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOperationsInput{}
	}

	req := c.newRequest(op, input, &ListOperationsOutput{})

	return ListOperationsRequest{Request: req, Input: input, Copy: c.ListOperationsRequest}
}

// ListOperationsRequest is the request type for the
// ListOperations API operation.
type ListOperationsRequest struct {
	*aws.Request
	Input *ListOperationsInput
	Copy  func(*ListOperationsInput) ListOperationsRequest
}

// Send marshals and sends the ListOperations API request.
func (r ListOperationsRequest) Send(ctx context.Context) (*ListOperationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListOperationsResponse{
		ListOperationsOutput: r.Request.Data.(*ListOperationsOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListOperationsRequestPaginator returns a paginator for ListOperations.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListOperationsRequest(input)
//   p := servicediscovery.NewListOperationsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListOperationsPaginator(req ListOperationsRequest) ListOperationsPaginator {
	return ListOperationsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListOperationsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListOperationsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListOperationsPaginator struct {
	aws.Pager
}

func (p *ListOperationsPaginator) CurrentPage() *ListOperationsOutput {
	return p.Pager.CurrentPage().(*ListOperationsOutput)
}

// ListOperationsResponse is the response type for the
// ListOperations API operation.
type ListOperationsResponse struct {
	*ListOperationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListOperations request.
func (r *ListOperationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
