// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package servicediscoveryiface provides an interface to enable mocking the AWS Cloud Map service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package servicediscoveryiface

import (
	"github.com/aws/aws-sdk-go-v2/service/servicediscovery"
)

// ClientAPI provides an interface to enable mocking the
// servicediscovery.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // ServiceDiscovery.
//    func myFunc(svc servicediscoveryiface.ClientAPI) bool {
//        // Make svc.CreateHttpNamespace request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := servicediscovery.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        servicediscoveryiface.ClientPI
//    }
//    func (m *mockClientClient) CreateHttpNamespace(input *servicediscovery.CreateHttpNamespaceInput) (*servicediscovery.CreateHttpNamespaceOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateHttpNamespaceRequest(*servicediscovery.CreateHttpNamespaceInput) servicediscovery.CreateHttpNamespaceRequest

	CreatePrivateDnsNamespaceRequest(*servicediscovery.CreatePrivateDnsNamespaceInput) servicediscovery.CreatePrivateDnsNamespaceRequest

	CreatePublicDnsNamespaceRequest(*servicediscovery.CreatePublicDnsNamespaceInput) servicediscovery.CreatePublicDnsNamespaceRequest

	CreateServiceRequest(*servicediscovery.CreateServiceInput) servicediscovery.CreateServiceRequest

	DeleteNamespaceRequest(*servicediscovery.DeleteNamespaceInput) servicediscovery.DeleteNamespaceRequest

	DeleteServiceRequest(*servicediscovery.DeleteServiceInput) servicediscovery.DeleteServiceRequest

	DeregisterInstanceRequest(*servicediscovery.DeregisterInstanceInput) servicediscovery.DeregisterInstanceRequest

	DiscoverInstancesRequest(*servicediscovery.DiscoverInstancesInput) servicediscovery.DiscoverInstancesRequest

	GetInstanceRequest(*servicediscovery.GetInstanceInput) servicediscovery.GetInstanceRequest

	GetInstancesHealthStatusRequest(*servicediscovery.GetInstancesHealthStatusInput) servicediscovery.GetInstancesHealthStatusRequest

	GetNamespaceRequest(*servicediscovery.GetNamespaceInput) servicediscovery.GetNamespaceRequest

	GetOperationRequest(*servicediscovery.GetOperationInput) servicediscovery.GetOperationRequest

	GetServiceRequest(*servicediscovery.GetServiceInput) servicediscovery.GetServiceRequest

	ListInstancesRequest(*servicediscovery.ListInstancesInput) servicediscovery.ListInstancesRequest

	ListNamespacesRequest(*servicediscovery.ListNamespacesInput) servicediscovery.ListNamespacesRequest

	ListOperationsRequest(*servicediscovery.ListOperationsInput) servicediscovery.ListOperationsRequest

	ListServicesRequest(*servicediscovery.ListServicesInput) servicediscovery.ListServicesRequest

	ListTagsForResourceRequest(*servicediscovery.ListTagsForResourceInput) servicediscovery.ListTagsForResourceRequest

	RegisterInstanceRequest(*servicediscovery.RegisterInstanceInput) servicediscovery.RegisterInstanceRequest

	TagResourceRequest(*servicediscovery.TagResourceInput) servicediscovery.TagResourceRequest

	UntagResourceRequest(*servicediscovery.UntagResourceInput) servicediscovery.UntagResourceRequest

	UpdateInstanceCustomHealthStatusRequest(*servicediscovery.UpdateInstanceCustomHealthStatusInput) servicediscovery.UpdateInstanceCustomHealthStatusRequest

	UpdateServiceRequest(*servicediscovery.UpdateServiceInput) servicediscovery.UpdateServiceRequest
}

var _ ClientAPI = (*servicediscovery.Client)(nil)
