// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicequotas

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListAWSDefaultServiceQuotasInput struct {
	_ struct{} `type:"structure"`

	// (Optional) Limits the number of results that you want to include in the response.
	// If you don't include this parameter, the response defaults to a value that's
	// specific to the operation. If additional items exist beyond the specified
	// maximum, the NextToken element is present and has a value (isn't null). Include
	// that value as the NextToken request parameter in the call to the operation
	// to get the next part of the results. You should check NextToken after every
	// operation to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) Use this parameter in a request if you receive a NextToken response
	// in a previous request that indicates that there's more output available.
	// In a subsequent call, set it to the value of the previous call's NextToken
	// response to indicate where the output should continue from. If additional
	// items exist beyond the specified maximum, the NextToken element is present
	// and has a value (isn't null). Include that value as the NextToken request
	// parameter in the call to the operation to get the next part of the results.
	// You should check NextToken after every operation to ensure that you receive
	// all of the results.
	NextToken *string `type:"string"`

	// Specifies the service that you want to use.
	//
	// ServiceCode is a required field
	ServiceCode *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListAWSDefaultServiceQuotasInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAWSDefaultServiceQuotasInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAWSDefaultServiceQuotasInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.ServiceCode == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceCode"))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListAWSDefaultServiceQuotasOutput struct {
	_ struct{} `type:"structure"`

	// (Optional) Use this parameter in a request if you receive a NextToken response
	// in a previous request that indicates that there's more output available.
	// In a subsequent call, set it to the value of the previous call's NextToken
	// response to indicate where the output should continue from.
	NextToken *string `type:"string"`

	// A list of the quotas in the account with the AWS default values.
	Quotas []ServiceQuota `type:"list"`
}

// String returns the string representation
func (s ListAWSDefaultServiceQuotasOutput) String() string {
	return awsutil.Prettify(s)
}

const opListAWSDefaultServiceQuotas = "ListAWSDefaultServiceQuotas"

// ListAWSDefaultServiceQuotasRequest returns a request value for making API operation for
// Service Quotas.
//
// Lists all default service quotas for the specified AWS service or all AWS
// services. ListAWSDefaultServiceQuotas is similar to ListServiceQuotas except
// for the Value object. The Value object returned by ListAWSDefaultServiceQuotas
// is the default value assigned by AWS. This request returns a list of all
// service quotas for the specified service. The listing of each you'll see
// the default values are the values that AWS provides for the quotas.
//
// Always check the NextToken response parameter when calling any of the List*
// operations. These operations can return an unexpected list of results, even
// when there are more results available. When this happens, the NextToken response
// parameter contains a value to pass the next call to the same API to request
// the next part of the list.
//
//    // Example sending a request using ListAWSDefaultServiceQuotasRequest.
//    req := client.ListAWSDefaultServiceQuotasRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListAWSDefaultServiceQuotas
func (c *Client) ListAWSDefaultServiceQuotasRequest(input *ListAWSDefaultServiceQuotasInput) ListAWSDefaultServiceQuotasRequest {
	op := &aws.Operation{
		Name:       opListAWSDefaultServiceQuotas,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAWSDefaultServiceQuotasInput{}
	}

	req := c.newRequest(op, input, &ListAWSDefaultServiceQuotasOutput{})

	return ListAWSDefaultServiceQuotasRequest{Request: req, Input: input, Copy: c.ListAWSDefaultServiceQuotasRequest}
}

// ListAWSDefaultServiceQuotasRequest is the request type for the
// ListAWSDefaultServiceQuotas API operation.
type ListAWSDefaultServiceQuotasRequest struct {
	*aws.Request
	Input *ListAWSDefaultServiceQuotasInput
	Copy  func(*ListAWSDefaultServiceQuotasInput) ListAWSDefaultServiceQuotasRequest
}

// Send marshals and sends the ListAWSDefaultServiceQuotas API request.
func (r ListAWSDefaultServiceQuotasRequest) Send(ctx context.Context) (*ListAWSDefaultServiceQuotasResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAWSDefaultServiceQuotasResponse{
		ListAWSDefaultServiceQuotasOutput: r.Request.Data.(*ListAWSDefaultServiceQuotasOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListAWSDefaultServiceQuotasRequestPaginator returns a paginator for ListAWSDefaultServiceQuotas.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListAWSDefaultServiceQuotasRequest(input)
//   p := servicequotas.NewListAWSDefaultServiceQuotasRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListAWSDefaultServiceQuotasPaginator(req ListAWSDefaultServiceQuotasRequest) ListAWSDefaultServiceQuotasPaginator {
	return ListAWSDefaultServiceQuotasPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListAWSDefaultServiceQuotasInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListAWSDefaultServiceQuotasPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListAWSDefaultServiceQuotasPaginator struct {
	aws.Pager
}

func (p *ListAWSDefaultServiceQuotasPaginator) CurrentPage() *ListAWSDefaultServiceQuotasOutput {
	return p.Pager.CurrentPage().(*ListAWSDefaultServiceQuotasOutput)
}

// ListAWSDefaultServiceQuotasResponse is the response type for the
// ListAWSDefaultServiceQuotas API operation.
type ListAWSDefaultServiceQuotasResponse struct {
	*ListAWSDefaultServiceQuotasOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAWSDefaultServiceQuotas request.
func (r *ListAWSDefaultServiceQuotasResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
