// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicequotas

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListRequestedServiceQuotaChangeHistoryByQuotaInput struct {
	_ struct{} `type:"structure"`

	// (Optional) Limits the number of results that you want to include in the response.
	// If you don't include this parameter, the response defaults to a value that's
	// specific to the operation. If additional items exist beyond the specified
	// maximum, the NextToken element is present and has a value (isn't null). Include
	// that value as the NextToken request parameter in the call to the operation
	// to get the next part of the results. You should check NextToken after every
	// operation to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) Use this parameter in a request if you receive a NextToken response
	// in a previous request that indicates that there's more output available.
	// In a subsequent call, set it to the value of the previous call's NextToken
	// response to indicate where the output should continue from.
	NextToken *string `type:"string"`

	// Specifies the service quota that you want to use
	//
	// QuotaCode is a required field
	QuotaCode *string `min:"1" type:"string" required:"true"`

	// Specifies the service that you want to use.
	//
	// ServiceCode is a required field
	ServiceCode *string `min:"1" type:"string" required:"true"`

	// Specifies the status value of the quota increase request.
	Status RequestStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s ListRequestedServiceQuotaChangeHistoryByQuotaInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRequestedServiceQuotaChangeHistoryByQuotaInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListRequestedServiceQuotaChangeHistoryByQuotaInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.QuotaCode == nil {
		invalidParams.Add(aws.NewErrParamRequired("QuotaCode"))
	}
	if s.QuotaCode != nil && len(*s.QuotaCode) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("QuotaCode", 1))
	}

	if s.ServiceCode == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceCode"))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListRequestedServiceQuotaChangeHistoryByQuotaOutput struct {
	_ struct{} `type:"structure"`

	// If present in the response, this value indicates there's more output available
	// that what's included in the current response. This can occur even when the
	// response includes no values at all, such as when you ask for a filtered view
	// of a very long list. Use this value in the NextToken request parameter in
	// a subsequent call to the operation to continue processing and get the next
	// part of the output. You should repeat this until the NextToken response element
	// comes back empty (as null).
	NextToken *string `type:"string"`

	// Returns a list of service quota requests.
	RequestedQuotas []RequestedServiceQuotaChange `type:"list"`
}

// String returns the string representation
func (s ListRequestedServiceQuotaChangeHistoryByQuotaOutput) String() string {
	return awsutil.Prettify(s)
}

const opListRequestedServiceQuotaChangeHistoryByQuota = "ListRequestedServiceQuotaChangeHistoryByQuota"

// ListRequestedServiceQuotaChangeHistoryByQuotaRequest returns a request value for making API operation for
// Service Quotas.
//
// Requests a list of the changes to specific service quotas. This command provides
// additional granularity over the ListRequestedServiceQuotaChangeHistory command.
// Once a quota change request has reached CASE_CLOSED, APPROVED, or DENIED,
// the history has been kept for 90 days.
//
//    // Example sending a request using ListRequestedServiceQuotaChangeHistoryByQuotaRequest.
//    req := client.ListRequestedServiceQuotaChangeHistoryByQuotaRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistoryByQuota
func (c *Client) ListRequestedServiceQuotaChangeHistoryByQuotaRequest(input *ListRequestedServiceQuotaChangeHistoryByQuotaInput) ListRequestedServiceQuotaChangeHistoryByQuotaRequest {
	op := &aws.Operation{
		Name:       opListRequestedServiceQuotaChangeHistoryByQuota,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRequestedServiceQuotaChangeHistoryByQuotaInput{}
	}

	req := c.newRequest(op, input, &ListRequestedServiceQuotaChangeHistoryByQuotaOutput{})

	return ListRequestedServiceQuotaChangeHistoryByQuotaRequest{Request: req, Input: input, Copy: c.ListRequestedServiceQuotaChangeHistoryByQuotaRequest}
}

// ListRequestedServiceQuotaChangeHistoryByQuotaRequest is the request type for the
// ListRequestedServiceQuotaChangeHistoryByQuota API operation.
type ListRequestedServiceQuotaChangeHistoryByQuotaRequest struct {
	*aws.Request
	Input *ListRequestedServiceQuotaChangeHistoryByQuotaInput
	Copy  func(*ListRequestedServiceQuotaChangeHistoryByQuotaInput) ListRequestedServiceQuotaChangeHistoryByQuotaRequest
}

// Send marshals and sends the ListRequestedServiceQuotaChangeHistoryByQuota API request.
func (r ListRequestedServiceQuotaChangeHistoryByQuotaRequest) Send(ctx context.Context) (*ListRequestedServiceQuotaChangeHistoryByQuotaResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListRequestedServiceQuotaChangeHistoryByQuotaResponse{
		ListRequestedServiceQuotaChangeHistoryByQuotaOutput: r.Request.Data.(*ListRequestedServiceQuotaChangeHistoryByQuotaOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListRequestedServiceQuotaChangeHistoryByQuotaRequestPaginator returns a paginator for ListRequestedServiceQuotaChangeHistoryByQuota.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListRequestedServiceQuotaChangeHistoryByQuotaRequest(input)
//   p := servicequotas.NewListRequestedServiceQuotaChangeHistoryByQuotaRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListRequestedServiceQuotaChangeHistoryByQuotaPaginator(req ListRequestedServiceQuotaChangeHistoryByQuotaRequest) ListRequestedServiceQuotaChangeHistoryByQuotaPaginator {
	return ListRequestedServiceQuotaChangeHistoryByQuotaPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListRequestedServiceQuotaChangeHistoryByQuotaInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListRequestedServiceQuotaChangeHistoryByQuotaPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListRequestedServiceQuotaChangeHistoryByQuotaPaginator struct {
	aws.Pager
}

func (p *ListRequestedServiceQuotaChangeHistoryByQuotaPaginator) CurrentPage() *ListRequestedServiceQuotaChangeHistoryByQuotaOutput {
	return p.Pager.CurrentPage().(*ListRequestedServiceQuotaChangeHistoryByQuotaOutput)
}

// ListRequestedServiceQuotaChangeHistoryByQuotaResponse is the response type for the
// ListRequestedServiceQuotaChangeHistoryByQuota API operation.
type ListRequestedServiceQuotaChangeHistoryByQuotaResponse struct {
	*ListRequestedServiceQuotaChangeHistoryByQuotaOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListRequestedServiceQuotaChangeHistoryByQuota request.
func (r *ListRequestedServiceQuotaChangeHistoryByQuotaResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
