// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicequotas

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListServiceQuotaIncreaseRequestsInTemplateInput struct {
	_ struct{} `type:"structure"`

	// Specifies the AWS Region for the quota that you want to use.
	AwsRegion *string `min:"1" type:"string"`

	// (Optional) Limits the number of results that you want to include in the response.
	// If you don't include this parameter, the response defaults to a value that's
	// specific to the operation. If additional items exist beyond the specified
	// maximum, the NextToken element is present and has a value (isn't null). Include
	// that value as the NextToken request parameter in the call to the operation
	// to get the next part of the results. You should check NextToken after every
	// operation to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) Use this parameter in a request if you receive a NextToken response
	// in a previous request that indicates that there's more output available.
	// In a subsequent call, set it to the value of the previous call's NextToken
	// response to indicate where the output should continue from.
	NextToken *string `type:"string"`

	// The identifier for a service. When performing an operation, use the ServiceCode
	// to specify a particular service.
	ServiceCode *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListServiceQuotaIncreaseRequestsInTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServiceQuotaIncreaseRequestsInTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListServiceQuotaIncreaseRequestsInTemplateInput"}
	if s.AwsRegion != nil && len(*s.AwsRegion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsRegion", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServiceCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListServiceQuotaIncreaseRequestsInTemplateOutput struct {
	_ struct{} `type:"structure"`

	// If present in the response, this value indicates there's more output available
	// that what's included in the current response. This can occur even when the
	// response includes no values at all, such as when you ask for a filtered view
	// of a very long list. Use this value in the NextToken request parameter in
	// a subsequent call to the operation to continue processing and get the next
	// part of the output. You should repeat this until the NextToken response element
	// comes back empty (as null).
	NextToken *string `type:"string"`

	// Returns the list of values of the quota increase request in the template.
	ServiceQuotaIncreaseRequestInTemplateList []ServiceQuotaIncreaseRequestInTemplate `type:"list"`
}

// String returns the string representation
func (s ListServiceQuotaIncreaseRequestsInTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

const opListServiceQuotaIncreaseRequestsInTemplate = "ListServiceQuotaIncreaseRequestsInTemplate"

// ListServiceQuotaIncreaseRequestsInTemplateRequest returns a request value for making API operation for
// Service Quotas.
//
// Returns a list of the quota increase requests in the template.
//
//    // Example sending a request using ListServiceQuotaIncreaseRequestsInTemplateRequest.
//    req := client.ListServiceQuotaIncreaseRequestsInTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotaIncreaseRequestsInTemplate
func (c *Client) ListServiceQuotaIncreaseRequestsInTemplateRequest(input *ListServiceQuotaIncreaseRequestsInTemplateInput) ListServiceQuotaIncreaseRequestsInTemplateRequest {
	op := &aws.Operation{
		Name:       opListServiceQuotaIncreaseRequestsInTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServiceQuotaIncreaseRequestsInTemplateInput{}
	}

	req := c.newRequest(op, input, &ListServiceQuotaIncreaseRequestsInTemplateOutput{})

	return ListServiceQuotaIncreaseRequestsInTemplateRequest{Request: req, Input: input, Copy: c.ListServiceQuotaIncreaseRequestsInTemplateRequest}
}

// ListServiceQuotaIncreaseRequestsInTemplateRequest is the request type for the
// ListServiceQuotaIncreaseRequestsInTemplate API operation.
type ListServiceQuotaIncreaseRequestsInTemplateRequest struct {
	*aws.Request
	Input *ListServiceQuotaIncreaseRequestsInTemplateInput
	Copy  func(*ListServiceQuotaIncreaseRequestsInTemplateInput) ListServiceQuotaIncreaseRequestsInTemplateRequest
}

// Send marshals and sends the ListServiceQuotaIncreaseRequestsInTemplate API request.
func (r ListServiceQuotaIncreaseRequestsInTemplateRequest) Send(ctx context.Context) (*ListServiceQuotaIncreaseRequestsInTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListServiceQuotaIncreaseRequestsInTemplateResponse{
		ListServiceQuotaIncreaseRequestsInTemplateOutput: r.Request.Data.(*ListServiceQuotaIncreaseRequestsInTemplateOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListServiceQuotaIncreaseRequestsInTemplateRequestPaginator returns a paginator for ListServiceQuotaIncreaseRequestsInTemplate.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListServiceQuotaIncreaseRequestsInTemplateRequest(input)
//   p := servicequotas.NewListServiceQuotaIncreaseRequestsInTemplateRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListServiceQuotaIncreaseRequestsInTemplatePaginator(req ListServiceQuotaIncreaseRequestsInTemplateRequest) ListServiceQuotaIncreaseRequestsInTemplatePaginator {
	return ListServiceQuotaIncreaseRequestsInTemplatePaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListServiceQuotaIncreaseRequestsInTemplateInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListServiceQuotaIncreaseRequestsInTemplatePaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListServiceQuotaIncreaseRequestsInTemplatePaginator struct {
	aws.Pager
}

func (p *ListServiceQuotaIncreaseRequestsInTemplatePaginator) CurrentPage() *ListServiceQuotaIncreaseRequestsInTemplateOutput {
	return p.Pager.CurrentPage().(*ListServiceQuotaIncreaseRequestsInTemplateOutput)
}

// ListServiceQuotaIncreaseRequestsInTemplateResponse is the response type for the
// ListServiceQuotaIncreaseRequestsInTemplate API operation.
type ListServiceQuotaIncreaseRequestsInTemplateResponse struct {
	*ListServiceQuotaIncreaseRequestsInTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListServiceQuotaIncreaseRequestsInTemplate request.
func (r *ListServiceQuotaIncreaseRequestsInTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
