// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to create an open and click tracking option object in
// a configuration set.
type CreateConfigurationSetTrackingOptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that the tracking options should be associated
	// with.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `type:"string" required:"true"`

	// A domain that is used to redirect email recipients to an Amazon SES-operated
	// domain. This domain captures open and click events generated by Amazon SES
	// emails.
	//
	// For more information, see Configuring Custom Domains to Handle Open and Click
	// Tracking (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html)
	// in the Amazon SES Developer Guide.
	//
	// TrackingOptions is a required field
	TrackingOptions *TrackingOptions `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateConfigurationSetTrackingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfigurationSetTrackingOptionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateConfigurationSetTrackingOptionsInput"}

	if s.ConfigurationSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigurationSetName"))
	}

	if s.TrackingOptions == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrackingOptions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An empty element returned on a successful request.
type CreateConfigurationSetTrackingOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateConfigurationSetTrackingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateConfigurationSetTrackingOptions = "CreateConfigurationSetTrackingOptions"

// CreateConfigurationSetTrackingOptionsRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Creates an association between a configuration set and a custom domain for
// open and click event tracking.
//
// By default, images and links used for tracking open and click events are
// hosted on domains operated by Amazon SES. You can configure a subdomain of
// your own to handle these events. For information about using custom domains,
// see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html).
//
//    // Example sending a request using CreateConfigurationSetTrackingOptionsRequest.
//    req := client.CreateConfigurationSetTrackingOptionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSetTrackingOptions
func (c *Client) CreateConfigurationSetTrackingOptionsRequest(input *CreateConfigurationSetTrackingOptionsInput) CreateConfigurationSetTrackingOptionsRequest {
	op := &aws.Operation{
		Name:       opCreateConfigurationSetTrackingOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConfigurationSetTrackingOptionsInput{}
	}

	req := c.newRequest(op, input, &CreateConfigurationSetTrackingOptionsOutput{})

	return CreateConfigurationSetTrackingOptionsRequest{Request: req, Input: input, Copy: c.CreateConfigurationSetTrackingOptionsRequest}
}

// CreateConfigurationSetTrackingOptionsRequest is the request type for the
// CreateConfigurationSetTrackingOptions API operation.
type CreateConfigurationSetTrackingOptionsRequest struct {
	*aws.Request
	Input *CreateConfigurationSetTrackingOptionsInput
	Copy  func(*CreateConfigurationSetTrackingOptionsInput) CreateConfigurationSetTrackingOptionsRequest
}

// Send marshals and sends the CreateConfigurationSetTrackingOptions API request.
func (r CreateConfigurationSetTrackingOptionsRequest) Send(ctx context.Context) (*CreateConfigurationSetTrackingOptionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateConfigurationSetTrackingOptionsResponse{
		CreateConfigurationSetTrackingOptionsOutput: r.Request.Data.(*CreateConfigurationSetTrackingOptionsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateConfigurationSetTrackingOptionsResponse is the response type for the
// CreateConfigurationSetTrackingOptions API operation.
type CreateConfigurationSetTrackingOptionsResponse struct {
	*CreateConfigurationSetTrackingOptionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateConfigurationSetTrackingOptions request.
func (r *CreateConfigurationSetTrackingOptionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
