// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to delete a receipt rule set and all of the receipt
// rules it contains. You use receipt rule sets to receive email with Amazon
// SES. For more information, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html).
type DeleteReceiptRuleSetInput struct {
	_ struct{} `type:"structure"`

	// The name of the receipt rule set to delete.
	//
	// RuleSetName is a required field
	RuleSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReceiptRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReceiptRuleSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteReceiptRuleSetInput"}

	if s.RuleSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An empty element returned on a successful request.
type DeleteReceiptRuleSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteReceiptRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteReceiptRuleSet = "DeleteReceiptRuleSet"

// DeleteReceiptRuleSetRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Deletes the specified receipt rule set and all of the receipt rules it contains.
//
// The currently active rule set cannot be deleted.
//
// For information about managing receipt rule sets, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html).
//
// You can execute this operation no more than once per second.
//
//    // Example sending a request using DeleteReceiptRuleSetRequest.
//    req := client.DeleteReceiptRuleSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptRuleSet
func (c *Client) DeleteReceiptRuleSetRequest(input *DeleteReceiptRuleSetInput) DeleteReceiptRuleSetRequest {
	op := &aws.Operation{
		Name:       opDeleteReceiptRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReceiptRuleSetInput{}
	}

	req := c.newRequest(op, input, &DeleteReceiptRuleSetOutput{})

	return DeleteReceiptRuleSetRequest{Request: req, Input: input, Copy: c.DeleteReceiptRuleSetRequest}
}

// DeleteReceiptRuleSetRequest is the request type for the
// DeleteReceiptRuleSet API operation.
type DeleteReceiptRuleSetRequest struct {
	*aws.Request
	Input *DeleteReceiptRuleSetInput
	Copy  func(*DeleteReceiptRuleSetInput) DeleteReceiptRuleSetRequest
}

// Send marshals and sends the DeleteReceiptRuleSet API request.
func (r DeleteReceiptRuleSetRequest) Send(ctx context.Context) (*DeleteReceiptRuleSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteReceiptRuleSetResponse{
		DeleteReceiptRuleSetOutput: r.Request.Data.(*DeleteReceiptRuleSetOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteReceiptRuleSetResponse is the response type for the
// DeleteReceiptRuleSet API operation.
type DeleteReceiptRuleSetResponse struct {
	*DeleteReceiptRuleSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteReceiptRuleSet request.
func (r *DeleteReceiptRuleSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
