// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListVerifiedEmailAddressesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListVerifiedEmailAddressesInput) String() string {
	return awsutil.Prettify(s)
}

// A list of email addresses that you have verified with Amazon SES under your
// AWS account.
type ListVerifiedEmailAddressesOutput struct {
	_ struct{} `type:"structure"`

	// A list of email addresses that have been verified.
	VerifiedEmailAddresses []string `type:"list"`
}

// String returns the string representation
func (s ListVerifiedEmailAddressesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListVerifiedEmailAddresses = "ListVerifiedEmailAddresses"

// ListVerifiedEmailAddressesRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Deprecated. Use the ListIdentities operation to list the email addresses
// and domains associated with your account.
//
//    // Example sending a request using ListVerifiedEmailAddressesRequest.
//    req := client.ListVerifiedEmailAddressesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListVerifiedEmailAddresses
func (c *Client) ListVerifiedEmailAddressesRequest(input *ListVerifiedEmailAddressesInput) ListVerifiedEmailAddressesRequest {
	op := &aws.Operation{
		Name:       opListVerifiedEmailAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListVerifiedEmailAddressesInput{}
	}

	req := c.newRequest(op, input, &ListVerifiedEmailAddressesOutput{})

	return ListVerifiedEmailAddressesRequest{Request: req, Input: input, Copy: c.ListVerifiedEmailAddressesRequest}
}

// ListVerifiedEmailAddressesRequest is the request type for the
// ListVerifiedEmailAddresses API operation.
type ListVerifiedEmailAddressesRequest struct {
	*aws.Request
	Input *ListVerifiedEmailAddressesInput
	Copy  func(*ListVerifiedEmailAddressesInput) ListVerifiedEmailAddressesRequest
}

// Send marshals and sends the ListVerifiedEmailAddresses API request.
func (r ListVerifiedEmailAddressesRequest) Send(ctx context.Context) (*ListVerifiedEmailAddressesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListVerifiedEmailAddressesResponse{
		ListVerifiedEmailAddressesOutput: r.Request.Data.(*ListVerifiedEmailAddressesOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListVerifiedEmailAddressesResponse is the response type for the
// ListVerifiedEmailAddresses API operation.
type ListVerifiedEmailAddressesResponse struct {
	*ListVerifiedEmailAddressesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListVerifiedEmailAddresses request.
func (r *ListVerifiedEmailAddressesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
