// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to add or update a sending authorization policy for
// an identity. Sending authorization is an Amazon SES feature that enables
// you to authorize other senders to use your identities. For information, see
// the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
type PutIdentityPolicyInput struct {
	_ struct{} `type:"structure"`

	// The identity that the policy will apply to. You can specify an identity by
	// using its name or by using its Amazon Resource Name (ARN). Examples: user@example.com,
	// example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	//
	// To successfully call this API, you must own the identity.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`

	// The text of the policy in JSON format. The policy cannot exceed 4 KB.
	//
	// For information about the syntax of sending authorization policies, see the
	// Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html).
	//
	// Policy is a required field
	Policy *string `min:"1" type:"string" required:"true"`

	// The name of the policy.
	//
	// The policy name cannot exceed 64 characters and can only include alphanumeric
	// characters, dashes, and underscores.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutIdentityPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutIdentityPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutIdentityPolicyInput"}

	if s.Identity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Identity"))
	}

	if s.Policy == nil {
		invalidParams.Add(aws.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Policy", 1))
	}

	if s.PolicyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An empty element returned on a successful request.
type PutIdentityPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutIdentityPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutIdentityPolicy = "PutIdentityPolicy"

// PutIdentityPolicyRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Adds or updates a sending authorization policy for the specified identity
// (an email address or a domain).
//
// This API is for the identity owner only. If you have not verified the identity,
// this API will return an error.
//
// Sending authorization is a feature that enables an identity owner to authorize
// other senders to use its identities. For information about using sending
// authorization, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
//
// You can execute this operation no more than once per second.
//
//    // Example sending a request using PutIdentityPolicyRequest.
//    req := client.PutIdentityPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/PutIdentityPolicy
func (c *Client) PutIdentityPolicyRequest(input *PutIdentityPolicyInput) PutIdentityPolicyRequest {
	op := &aws.Operation{
		Name:       opPutIdentityPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutIdentityPolicyInput{}
	}

	req := c.newRequest(op, input, &PutIdentityPolicyOutput{})

	return PutIdentityPolicyRequest{Request: req, Input: input, Copy: c.PutIdentityPolicyRequest}
}

// PutIdentityPolicyRequest is the request type for the
// PutIdentityPolicy API operation.
type PutIdentityPolicyRequest struct {
	*aws.Request
	Input *PutIdentityPolicyInput
	Copy  func(*PutIdentityPolicyInput) PutIdentityPolicyRequest
}

// Send marshals and sends the PutIdentityPolicy API request.
func (r PutIdentityPolicyRequest) Send(ctx context.Context) (*PutIdentityPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutIdentityPolicyResponse{
		PutIdentityPolicyOutput: r.Request.Data.(*PutIdentityPolicyOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutIdentityPolicyResponse is the response type for the
// PutIdentityPolicy API operation.
type PutIdentityPolicyResponse struct {
	*PutIdentityPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutIdentityPolicy request.
func (r *PutIdentityPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
