// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sesv2

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A request to begin the verification process for an email identity (an email
// address or domain).
type CreateEmailIdentityInput struct {
	_ struct{} `type:"structure"`

	// If your request includes this object, Amazon SES configures the identity
	// to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, as
	// opposed to the default method, Easy DKIM (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
	//
	// You can only specify this object if the email identity is a domain, as opposed
	// to an address.
	DkimSigningAttributes *DkimSigningAttributes `type:"structure"`

	// The email address or domain that you want to verify.
	//
	// EmailIdentity is a required field
	EmailIdentity *string `type:"string" required:"true"`

	// An array of objects that define the tags (keys and values) that you want
	// to associate with the email identity.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s CreateEmailIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEmailIdentityInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateEmailIdentityInput"}

	if s.EmailIdentity == nil {
		invalidParams.Add(aws.NewErrParamRequired("EmailIdentity"))
	}
	if s.DkimSigningAttributes != nil {
		if err := s.DkimSigningAttributes.Validate(); err != nil {
			invalidParams.AddNested("DkimSigningAttributes", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateEmailIdentityInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DkimSigningAttributes != nil {
		v := s.DkimSigningAttributes

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DkimSigningAttributes", v, metadata)
	}
	if s.EmailIdentity != nil {
		v := *s.EmailIdentity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EmailIdentity", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// If the email identity is a domain, this object contains information about
// the DKIM verification status for the domain.
//
// If the email identity is an email address, this object is empty.
type CreateEmailIdentityOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about the DKIM attributes for the identity.
	DkimAttributes *DkimAttributes `type:"structure"`

	// The email identity type.
	IdentityType IdentityType `type:"string" enum:"true"`

	// Specifies whether or not the identity is verified. You can only send email
	// from verified email addresses or domains. For more information about verifying
	// identities, see the Amazon Pinpoint User Guide (https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html).
	VerifiedForSendingStatus *bool `type:"boolean"`
}

// String returns the string representation
func (s CreateEmailIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateEmailIdentityOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DkimAttributes != nil {
		v := s.DkimAttributes

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DkimAttributes", v, metadata)
	}
	if len(s.IdentityType) > 0 {
		v := s.IdentityType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IdentityType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.VerifiedForSendingStatus != nil {
		v := *s.VerifiedForSendingStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VerifiedForSendingStatus", protocol.BoolValue(v), metadata)
	}
	return nil
}

const opCreateEmailIdentity = "CreateEmailIdentity"

// CreateEmailIdentityRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Starts the process of verifying an email identity. An identity is an email
// address or domain that you use when you send email. Before you can use an
// identity to send email, you first have to verify it. By verifying an identity,
// you demonstrate that you're the owner of the identity, and that you've given
// Amazon SES API v2 permission to send email from the identity.
//
// When you verify an email address, Amazon SES sends an email to the address.
// Your email address is verified as soon as you follow the link in the verification
// email.
//
// When you verify a domain without specifying the DkimSigningAttributes object,
// this operation provides a set of DKIM tokens. You can convert these tokens
// into CNAME records, which you then add to the DNS configuration for your
// domain. Your domain is verified when Amazon SES detects these records in
// the DNS configuration for your domain. This verification method is known
// as Easy DKIM (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
//
// Alternatively, you can perform the verification process by providing your
// own public-private key pair. This verification method is known as Bring Your
// Own DKIM (BYODKIM). To use BYODKIM, your call to the CreateEmailIdentity
// operation has to include the DkimSigningAttributes object. When you specify
// this object, you provide a selector (a component of the DNS record name that
// identifies the public key that you want to use for DKIM authentication) and
// a private key.
//
//    // Example sending a request using CreateEmailIdentityRequest.
//    req := client.CreateEmailIdentityRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateEmailIdentity
func (c *Client) CreateEmailIdentityRequest(input *CreateEmailIdentityInput) CreateEmailIdentityRequest {
	op := &aws.Operation{
		Name:       opCreateEmailIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/email/identities",
	}

	if input == nil {
		input = &CreateEmailIdentityInput{}
	}

	req := c.newRequest(op, input, &CreateEmailIdentityOutput{})

	return CreateEmailIdentityRequest{Request: req, Input: input, Copy: c.CreateEmailIdentityRequest}
}

// CreateEmailIdentityRequest is the request type for the
// CreateEmailIdentity API operation.
type CreateEmailIdentityRequest struct {
	*aws.Request
	Input *CreateEmailIdentityInput
	Copy  func(*CreateEmailIdentityInput) CreateEmailIdentityRequest
}

// Send marshals and sends the CreateEmailIdentity API request.
func (r CreateEmailIdentityRequest) Send(ctx context.Context) (*CreateEmailIdentityResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateEmailIdentityResponse{
		CreateEmailIdentityOutput: r.Request.Data.(*CreateEmailIdentityOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateEmailIdentityResponse is the response type for the
// CreateEmailIdentity API operation.
type CreateEmailIdentityResponse struct {
	*CreateEmailIdentityOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateEmailIdentity request.
func (r *CreateEmailIdentityResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
