// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sesv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A request to change the account suppression list preferences for a specific
// configuration set.
type PutConfigurationSetSuppressionOptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that you want to change the suppression
	// list preferences for.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`

	// A list that contains the reasons that email addresses are automatically added
	// to the suppression list for your account. This list can contain any or all
	// of the following:
	//
	//    * COMPLAINT – Amazon SES adds an email address to the suppression list
	//    for your account when a message sent to that address results in a complaint.
	//
	//    * BOUNCE – Amazon SES adds an email address to the suppression list
	//    for your account when a message sent to that address results in a hard
	//    bounce.
	SuppressedReasons []SuppressionListReason `type:"list"`
}

// String returns the string representation
func (s PutConfigurationSetSuppressionOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutConfigurationSetSuppressionOptionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutConfigurationSetSuppressionOptionsInput"}

	if s.ConfigurationSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigurationSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutConfigurationSetSuppressionOptionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.SuppressedReasons != nil {
		v := s.SuppressedReasons

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SuppressedReasons", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.ConfigurationSetName != nil {
		v := *s.ConfigurationSetName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ConfigurationSetName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutConfigurationSetSuppressionOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutConfigurationSetSuppressionOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutConfigurationSetSuppressionOptionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opPutConfigurationSetSuppressionOptions = "PutConfigurationSetSuppressionOptions"

// PutConfigurationSetSuppressionOptionsRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Specify the account suppression list preferences for a configuration set.
//
//    // Example sending a request using PutConfigurationSetSuppressionOptionsRequest.
//    req := client.PutConfigurationSetSuppressionOptionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetSuppressionOptions
func (c *Client) PutConfigurationSetSuppressionOptionsRequest(input *PutConfigurationSetSuppressionOptionsInput) PutConfigurationSetSuppressionOptionsRequest {
	op := &aws.Operation{
		Name:       opPutConfigurationSetSuppressionOptions,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/email/configuration-sets/{ConfigurationSetName}/suppression-options",
	}

	if input == nil {
		input = &PutConfigurationSetSuppressionOptionsInput{}
	}

	req := c.newRequest(op, input, &PutConfigurationSetSuppressionOptionsOutput{})

	return PutConfigurationSetSuppressionOptionsRequest{Request: req, Input: input, Copy: c.PutConfigurationSetSuppressionOptionsRequest}
}

// PutConfigurationSetSuppressionOptionsRequest is the request type for the
// PutConfigurationSetSuppressionOptions API operation.
type PutConfigurationSetSuppressionOptionsRequest struct {
	*aws.Request
	Input *PutConfigurationSetSuppressionOptionsInput
	Copy  func(*PutConfigurationSetSuppressionOptionsInput) PutConfigurationSetSuppressionOptionsRequest
}

// Send marshals and sends the PutConfigurationSetSuppressionOptions API request.
func (r PutConfigurationSetSuppressionOptionsRequest) Send(ctx context.Context) (*PutConfigurationSetSuppressionOptionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutConfigurationSetSuppressionOptionsResponse{
		PutConfigurationSetSuppressionOptionsOutput: r.Request.Data.(*PutConfigurationSetSuppressionOptionsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutConfigurationSetSuppressionOptionsResponse is the response type for the
// PutConfigurationSetSuppressionOptions API operation.
type PutConfigurationSetSuppressionOptionsResponse struct {
	*PutConfigurationSetSuppressionOptionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutConfigurationSetSuppressionOptions request.
func (r *PutConfigurationSetSuppressionOptionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
