// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sesv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A request to add an email destination to the suppression list for your account.
type PutSuppressedDestinationInput struct {
	_ struct{} `type:"structure"`

	// The email address that should be added to the suppression list for your account.
	//
	// EmailAddress is a required field
	EmailAddress *string `type:"string" required:"true"`

	// The factors that should cause the email address to be added to the suppression
	// list for your account.
	//
	// Reason is a required field
	Reason SuppressionListReason `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s PutSuppressedDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutSuppressedDestinationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutSuppressedDestinationInput"}

	if s.EmailAddress == nil {
		invalidParams.Add(aws.NewErrParamRequired("EmailAddress"))
	}
	if len(s.Reason) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Reason"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutSuppressedDestinationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.EmailAddress != nil {
		v := *s.EmailAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EmailAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Reason) > 0 {
		v := s.Reason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Reason", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutSuppressedDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutSuppressedDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutSuppressedDestinationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opPutSuppressedDestination = "PutSuppressedDestination"

// PutSuppressedDestinationRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Adds an email address to the suppression list for your account.
//
//    // Example sending a request using PutSuppressedDestinationRequest.
//    req := client.PutSuppressedDestinationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutSuppressedDestination
func (c *Client) PutSuppressedDestinationRequest(input *PutSuppressedDestinationInput) PutSuppressedDestinationRequest {
	op := &aws.Operation{
		Name:       opPutSuppressedDestination,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/email/suppression/addresses",
	}

	if input == nil {
		input = &PutSuppressedDestinationInput{}
	}

	req := c.newRequest(op, input, &PutSuppressedDestinationOutput{})

	return PutSuppressedDestinationRequest{Request: req, Input: input, Copy: c.PutSuppressedDestinationRequest}
}

// PutSuppressedDestinationRequest is the request type for the
// PutSuppressedDestination API operation.
type PutSuppressedDestinationRequest struct {
	*aws.Request
	Input *PutSuppressedDestinationInput
	Copy  func(*PutSuppressedDestinationInput) PutSuppressedDestinationRequest
}

// Send marshals and sends the PutSuppressedDestination API request.
func (r PutSuppressedDestinationRequest) Send(ctx context.Context) (*PutSuppressedDestinationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutSuppressedDestinationResponse{
		PutSuppressedDestinationOutput: r.Request.Data.(*PutSuppressedDestinationOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutSuppressedDestinationResponse is the response type for the
// PutSuppressedDestination API operation.
type PutSuppressedDestinationResponse struct {
	*PutSuppressedDestinationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutSuppressedDestination request.
func (r *PutSuppressedDestinationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
