// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sfn

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateStateMachineInput struct {
	_ struct{} `type:"structure"`

	// The Amazon States Language definition of the state machine. See Amazon States
	// Language (https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html).
	Definition *string `locationName:"definition" min:"1" type:"string" sensitive:"true"`

	// The LoggingConfiguration data type is used to set CloudWatch Logs options.
	LoggingConfiguration *LoggingConfiguration `locationName:"loggingConfiguration" type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role of the state machine.
	RoleArn *string `locationName:"roleArn" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the state machine.
	//
	// StateMachineArn is a required field
	StateMachineArn *string `locationName:"stateMachineArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateStateMachineInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStateMachineInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateStateMachineInput"}
	if s.Definition != nil && len(*s.Definition) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Definition", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 1))
	}

	if s.StateMachineArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("StateMachineArn"))
	}
	if s.StateMachineArn != nil && len(*s.StateMachineArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StateMachineArn", 1))
	}
	if s.LoggingConfiguration != nil {
		if err := s.LoggingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LoggingConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateStateMachineOutput struct {
	_ struct{} `type:"structure"`

	// The date and time the state machine was updated.
	//
	// UpdateDate is a required field
	UpdateDate *time.Time `locationName:"updateDate" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s UpdateStateMachineOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateStateMachine = "UpdateStateMachine"

// UpdateStateMachineRequest returns a request value for making API operation for
// AWS Step Functions.
//
// Updates an existing state machine by modifying its definition, roleArn, or
// loggingConfiguration. Running executions will continue to use the previous
// definition and roleArn. You must include at least one of definition or roleArn
// or you will receive a MissingRequiredParameter error.
//
// All StartExecution calls within a few seconds will use the updated definition
// and roleArn. Executions started immediately after calling UpdateStateMachine
// may use the previous state machine definition and roleArn.
//
//    // Example sending a request using UpdateStateMachineRequest.
//    req := client.UpdateStateMachineRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/UpdateStateMachine
func (c *Client) UpdateStateMachineRequest(input *UpdateStateMachineInput) UpdateStateMachineRequest {
	op := &aws.Operation{
		Name:       opUpdateStateMachine,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateStateMachineInput{}
	}

	req := c.newRequest(op, input, &UpdateStateMachineOutput{})

	return UpdateStateMachineRequest{Request: req, Input: input, Copy: c.UpdateStateMachineRequest}
}

// UpdateStateMachineRequest is the request type for the
// UpdateStateMachine API operation.
type UpdateStateMachineRequest struct {
	*aws.Request
	Input *UpdateStateMachineInput
	Copy  func(*UpdateStateMachineInput) UpdateStateMachineRequest
}

// Send marshals and sends the UpdateStateMachine API request.
func (r UpdateStateMachineRequest) Send(ctx context.Context) (*UpdateStateMachineResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateStateMachineResponse{
		UpdateStateMachineOutput: r.Request.Data.(*UpdateStateMachineOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateStateMachineResponse is the response type for the
// UpdateStateMachine API operation.
type UpdateStateMachineResponse struct {
	*UpdateStateMachineOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateStateMachine request.
func (r *UpdateStateMachineResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
