// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package shield

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type AssociateHealthCheckInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the health check to associate with the
	// protection.
	//
	// HealthCheckArn is a required field
	HealthCheckArn *string `min:"1" type:"string" required:"true"`

	// The unique identifier (ID) for the Protection object to add the health check
	// association to.
	//
	// ProtectionId is a required field
	ProtectionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateHealthCheckInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateHealthCheckInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateHealthCheckInput"}

	if s.HealthCheckArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("HealthCheckArn"))
	}
	if s.HealthCheckArn != nil && len(*s.HealthCheckArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("HealthCheckArn", 1))
	}

	if s.ProtectionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProtectionId"))
	}
	if s.ProtectionId != nil && len(*s.ProtectionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProtectionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AssociateHealthCheckOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateHealthCheckOutput) String() string {
	return awsutil.Prettify(s)
}

const opAssociateHealthCheck = "AssociateHealthCheck"

// AssociateHealthCheckRequest returns a request value for making API operation for
// AWS Shield.
//
// Adds health-based detection to the Shield Advanced protection for a resource.
// Shield Advanced health-based detection uses the health of your AWS resource
// to improve responsiveness and accuracy in attack detection and mitigation.
//
// You define the health check in Route 53 and then associate it with your Shield
// Advanced protection. For more information, see Shield Advanced Health-Based
// Detection (https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option)
// in the AWS WAF and AWS Shield Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
//    // Example sending a request using AssociateHealthCheckRequest.
//    req := client.AssociateHealthCheckRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateHealthCheck
func (c *Client) AssociateHealthCheckRequest(input *AssociateHealthCheckInput) AssociateHealthCheckRequest {
	op := &aws.Operation{
		Name:       opAssociateHealthCheck,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateHealthCheckInput{}
	}

	req := c.newRequest(op, input, &AssociateHealthCheckOutput{})

	return AssociateHealthCheckRequest{Request: req, Input: input, Copy: c.AssociateHealthCheckRequest}
}

// AssociateHealthCheckRequest is the request type for the
// AssociateHealthCheck API operation.
type AssociateHealthCheckRequest struct {
	*aws.Request
	Input *AssociateHealthCheckInput
	Copy  func(*AssociateHealthCheckInput) AssociateHealthCheckRequest
}

// Send marshals and sends the AssociateHealthCheck API request.
func (r AssociateHealthCheckRequest) Send(ctx context.Context) (*AssociateHealthCheckResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociateHealthCheckResponse{
		AssociateHealthCheckOutput: r.Request.Data.(*AssociateHealthCheckOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociateHealthCheckResponse is the response type for the
// AssociateHealthCheck API operation.
type AssociateHealthCheckResponse struct {
	*AssociateHealthCheckOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociateHealthCheck request.
func (r *AssociateHealthCheckResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
