// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package shield

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DisassociateHealthCheckInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the health check that is associated with
	// the protection.
	//
	// HealthCheckArn is a required field
	HealthCheckArn *string `min:"1" type:"string" required:"true"`

	// The unique identifier (ID) for the Protection object to remove the health
	// check association from.
	//
	// ProtectionId is a required field
	ProtectionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateHealthCheckInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateHealthCheckInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateHealthCheckInput"}

	if s.HealthCheckArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("HealthCheckArn"))
	}
	if s.HealthCheckArn != nil && len(*s.HealthCheckArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("HealthCheckArn", 1))
	}

	if s.ProtectionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProtectionId"))
	}
	if s.ProtectionId != nil && len(*s.ProtectionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProtectionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisassociateHealthCheckOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateHealthCheckOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisassociateHealthCheck = "DisassociateHealthCheck"

// DisassociateHealthCheckRequest returns a request value for making API operation for
// AWS Shield.
//
// Removes health-based detection from the Shield Advanced protection for a
// resource. Shield Advanced health-based detection uses the health of your
// AWS resource to improve responsiveness and accuracy in attack detection and
// mitigation.
//
// You define the health check in Route 53 and then associate or disassociate
// it with your Shield Advanced protection. For more information, see Shield
// Advanced Health-Based Detection (https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option)
// in the AWS WAF and AWS Shield Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
//    // Example sending a request using DisassociateHealthCheckRequest.
//    req := client.DisassociateHealthCheckRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateHealthCheck
func (c *Client) DisassociateHealthCheckRequest(input *DisassociateHealthCheckInput) DisassociateHealthCheckRequest {
	op := &aws.Operation{
		Name:       opDisassociateHealthCheck,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateHealthCheckInput{}
	}

	req := c.newRequest(op, input, &DisassociateHealthCheckOutput{})

	return DisassociateHealthCheckRequest{Request: req, Input: input, Copy: c.DisassociateHealthCheckRequest}
}

// DisassociateHealthCheckRequest is the request type for the
// DisassociateHealthCheck API operation.
type DisassociateHealthCheckRequest struct {
	*aws.Request
	Input *DisassociateHealthCheckInput
	Copy  func(*DisassociateHealthCheckInput) DisassociateHealthCheckRequest
}

// Send marshals and sends the DisassociateHealthCheck API request.
func (r DisassociateHealthCheckRequest) Send(ctx context.Context) (*DisassociateHealthCheckResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateHealthCheckResponse{
		DisassociateHealthCheckOutput: r.Request.Data.(*DisassociateHealthCheckOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateHealthCheckResponse is the response type for the
// DisassociateHealthCheck API operation.
type DisassociateHealthCheckResponse struct {
	*DisassociateHealthCheckOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateHealthCheck request.
func (r *DisassociateHealthCheckResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
