// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package signer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListSigningPlatformsInput struct {
	_ struct{} `type:"structure"`

	// The category type of a signing platform.
	Category *string `location:"querystring" locationName:"category" type:"string"`

	// The maximum number of results to be returned by this operation.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Value for specifying the next set of paginated results to return. After you
	// receive a response with truncated results, use this parameter in a subsequent
	// request. Set it to the value of nextToken from the response that you just
	// received.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// Any partner entities connected to a signing platform.
	Partner *string `location:"querystring" locationName:"partner" type:"string"`

	// The validation template that is used by the target signing platform.
	Target *string `location:"querystring" locationName:"target" type:"string"`
}

// String returns the string representation
func (s ListSigningPlatformsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSigningPlatformsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListSigningPlatformsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListSigningPlatformsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Category != nil {
		v := *s.Category

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "category", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Partner != nil {
		v := *s.Partner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "partner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Target != nil {
		v := *s.Target

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "target", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListSigningPlatformsOutput struct {
	_ struct{} `type:"structure"`

	// Value for specifying the next set of paginated results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of all platforms that match the request parameters.
	Platforms []SigningPlatform `locationName:"platforms" type:"list"`
}

// String returns the string representation
func (s ListSigningPlatformsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListSigningPlatformsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Platforms != nil {
		v := s.Platforms

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "platforms", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListSigningPlatforms = "ListSigningPlatforms"

// ListSigningPlatformsRequest returns a request value for making API operation for
// AWS Signer.
//
// Lists all signing platforms available in code signing that match the request
// parameters. If additional jobs remain to be listed, code signing returns
// a nextToken value. Use this value in subsequent calls to ListSigningJobs
// to fetch the remaining values. You can continue calling ListSigningJobs with
// your maxResults parameter and with new values that code signing returns in
// the nextToken parameter until all of your signing jobs have been returned.
//
//    // Example sending a request using ListSigningPlatformsRequest.
//    req := client.ListSigningPlatformsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/ListSigningPlatforms
func (c *Client) ListSigningPlatformsRequest(input *ListSigningPlatformsInput) ListSigningPlatformsRequest {
	op := &aws.Operation{
		Name:       opListSigningPlatforms,
		HTTPMethod: "GET",
		HTTPPath:   "/signing-platforms",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSigningPlatformsInput{}
	}

	req := c.newRequest(op, input, &ListSigningPlatformsOutput{})

	return ListSigningPlatformsRequest{Request: req, Input: input, Copy: c.ListSigningPlatformsRequest}
}

// ListSigningPlatformsRequest is the request type for the
// ListSigningPlatforms API operation.
type ListSigningPlatformsRequest struct {
	*aws.Request
	Input *ListSigningPlatformsInput
	Copy  func(*ListSigningPlatformsInput) ListSigningPlatformsRequest
}

// Send marshals and sends the ListSigningPlatforms API request.
func (r ListSigningPlatformsRequest) Send(ctx context.Context) (*ListSigningPlatformsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListSigningPlatformsResponse{
		ListSigningPlatformsOutput: r.Request.Data.(*ListSigningPlatformsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListSigningPlatformsRequestPaginator returns a paginator for ListSigningPlatforms.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListSigningPlatformsRequest(input)
//   p := signer.NewListSigningPlatformsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListSigningPlatformsPaginator(req ListSigningPlatformsRequest) ListSigningPlatformsPaginator {
	return ListSigningPlatformsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListSigningPlatformsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListSigningPlatformsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListSigningPlatformsPaginator struct {
	aws.Pager
}

func (p *ListSigningPlatformsPaginator) CurrentPage() *ListSigningPlatformsOutput {
	return p.Pager.CurrentPage().(*ListSigningPlatformsOutput)
}

// ListSigningPlatformsResponse is the response type for the
// ListSigningPlatforms API operation.
type ListSigningPlatformsResponse struct {
	*ListSigningPlatformsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListSigningPlatforms request.
func (r *ListSigningPlatformsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
