// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package simpledb

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type DeleteAttributesInput struct {
	_ struct{} `type:"structure"`

	// A list of Attributes. Similar to columns on a spreadsheet, attributes represent
	// categories of data that can be assigned to items.
	Attributes []DeletableAttribute `locationNameList:"Attribute" type:"list" flattened:"true"`

	// The name of the domain in which to perform the operation.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// The update condition which, if specified, determines whether the specified
	// attributes will be deleted or not. The update condition must be satisfied
	// in order for this request to be processed and the attributes to be deleted.
	Expected *UpdateCondition `type:"structure"`

	// The name of the item. Similar to rows on a spreadsheet, items represent individual
	// objects that contain one or more value-attribute pairs.
	//
	// ItemName is a required field
	ItemName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAttributesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteAttributesInput"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}

	if s.ItemName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ItemName"))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteAttributes = "DeleteAttributes"

// DeleteAttributesRequest returns a request value for making API operation for
// Amazon SimpleDB.
//
// Deletes one or more attributes associated with an item. If all attributes
// of the item are deleted, the item is deleted.
//   If
//    DeleteAttributes
//  is called without being passed any attributes or values specified, all the
//  attributes for the item are deleted.
// DeleteAttributes is an idempotent operation; running it multiple times on
// the same item or attribute does not result in an error response.
//
// Because Amazon SimpleDB makes multiple copies of item data and uses an eventual
// consistency update model, performing a GetAttributes or Select operation
// (read) immediately after a DeleteAttributes or PutAttributes operation (write)
// might not return updated item data.
//
//    // Example sending a request using DeleteAttributesRequest.
//    req := client.DeleteAttributesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteAttributesRequest(input *DeleteAttributesInput) DeleteAttributesRequest {
	op := &aws.Operation{
		Name:       opDeleteAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAttributesInput{}
	}

	req := c.newRequest(op, input, &DeleteAttributesOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteAttributesRequest{Request: req, Input: input, Copy: c.DeleteAttributesRequest}
}

// DeleteAttributesRequest is the request type for the
// DeleteAttributes API operation.
type DeleteAttributesRequest struct {
	*aws.Request
	Input *DeleteAttributesInput
	Copy  func(*DeleteAttributesInput) DeleteAttributesRequest
}

// Send marshals and sends the DeleteAttributes API request.
func (r DeleteAttributesRequest) Send(ctx context.Context) (*DeleteAttributesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteAttributesResponse{
		DeleteAttributesOutput: r.Request.Data.(*DeleteAttributesOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteAttributesResponse is the response type for the
// DeleteAttributes API operation.
type DeleteAttributesResponse struct {
	*DeleteAttributesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteAttributes request.
func (r *DeleteAttributesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
