// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateAppInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier you provide to ensure idempotency of
	// application creation.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Description of the new application
	Description *string `locationName:"description" type:"string"`

	// Name of the new application.
	Name *string `locationName:"name" type:"string"`

	// Name of service role in customer's account to be used by AWS SMS.
	RoleName *string `locationName:"roleName" type:"string"`

	// List of server groups to include in the application.
	ServerGroups []ServerGroup `locationName:"serverGroups" type:"list"`

	// List of tags to be associated with the application.
	Tags []Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateAppInput) String() string {
	return awsutil.Prettify(s)
}

type CreateAppOutput struct {
	_ struct{} `type:"structure"`

	// Summary description of the application.
	AppSummary *AppSummary `locationName:"appSummary" type:"structure"`

	// List of server groups included in the application.
	ServerGroups []ServerGroup `locationName:"serverGroups" type:"list"`

	// List of taags associated with the application.
	Tags []Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateAppOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateApp = "CreateApp"

// CreateAppRequest returns a request value for making API operation for
// AWS Server Migration Service.
//
// Creates an application. An application consists of one or more server groups.
// Each server group contain one or more servers.
//
//    // Example sending a request using CreateAppRequest.
//    req := client.CreateAppRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/CreateApp
func (c *Client) CreateAppRequest(input *CreateAppInput) CreateAppRequest {
	op := &aws.Operation{
		Name:       opCreateApp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAppInput{}
	}

	req := c.newRequest(op, input, &CreateAppOutput{})

	return CreateAppRequest{Request: req, Input: input, Copy: c.CreateAppRequest}
}

// CreateAppRequest is the request type for the
// CreateApp API operation.
type CreateAppRequest struct {
	*aws.Request
	Input *CreateAppInput
	Copy  func(*CreateAppInput) CreateAppRequest
}

// Send marshals and sends the CreateApp API request.
func (r CreateAppRequest) Send(ctx context.Context) (*CreateAppResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateAppResponse{
		CreateAppOutput: r.Request.Data.(*CreateAppOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateAppResponse is the response type for the
// CreateApp API operation.
type CreateAppResponse struct {
	*CreateAppOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateApp request.
func (r *CreateAppResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
