// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package snowball

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeAddressesInput struct {
	_ struct{} `type:"structure"`

	// The number of ADDRESS objects to return.
	MaxResults *int64 `type:"integer"`

	// HTTP requests are stateless. To identify what object comes "next" in the
	// list of ADDRESS objects, you have the option of specifying a value for NextToken
	// as the starting point for your list of returned addresses.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeAddressesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAddressesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAddressesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeAddressesOutput struct {
	_ struct{} `type:"structure"`

	// The Snowball shipping addresses that were created for this account.
	Addresses []Address `type:"list"`

	// HTTP requests are stateless. If you use the automatically generated NextToken
	// value in your next DescribeAddresses call, your list of returned addresses
	// will start from this point in the array.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeAddressesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeAddresses = "DescribeAddresses"

// DescribeAddressesRequest returns a request value for making API operation for
// Amazon Import/Export Snowball.
//
// Returns a specified number of ADDRESS objects. Calling this API in one of
// the US regions will return addresses from the list of all addresses associated
// with this account in all US regions.
//
//    // Example sending a request using DescribeAddressesRequest.
//    req := client.DescribeAddressesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeAddresses
func (c *Client) DescribeAddressesRequest(input *DescribeAddressesInput) DescribeAddressesRequest {
	op := &aws.Operation{
		Name:       opDescribeAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAddressesInput{}
	}

	req := c.newRequest(op, input, &DescribeAddressesOutput{})

	return DescribeAddressesRequest{Request: req, Input: input, Copy: c.DescribeAddressesRequest}
}

// DescribeAddressesRequest is the request type for the
// DescribeAddresses API operation.
type DescribeAddressesRequest struct {
	*aws.Request
	Input *DescribeAddressesInput
	Copy  func(*DescribeAddressesInput) DescribeAddressesRequest
}

// Send marshals and sends the DescribeAddresses API request.
func (r DescribeAddressesRequest) Send(ctx context.Context) (*DescribeAddressesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAddressesResponse{
		DescribeAddressesOutput: r.Request.Data.(*DescribeAddressesOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeAddressesRequestPaginator returns a paginator for DescribeAddresses.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeAddressesRequest(input)
//   p := snowball.NewDescribeAddressesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeAddressesPaginator(req DescribeAddressesRequest) DescribeAddressesPaginator {
	return DescribeAddressesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeAddressesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeAddressesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeAddressesPaginator struct {
	aws.Pager
}

func (p *DescribeAddressesPaginator) CurrentPage() *DescribeAddressesOutput {
	return p.Pager.CurrentPage().(*DescribeAddressesOutput)
}

// DescribeAddressesResponse is the response type for the
// DescribeAddresses API operation.
type DescribeAddressesResponse struct {
	*DescribeAddressesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAddresses request.
func (r *DescribeAddressesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
