// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package snowball

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListClustersInput struct {
	_ struct{} `type:"structure"`

	// The number of ClusterListEntry objects to return.
	MaxResults *int64 `type:"integer"`

	// HTTP requests are stateless. To identify what object comes "next" in the
	// list of ClusterListEntry objects, you have the option of specifying NextToken
	// as the starting point for your returned list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListClustersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListClustersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListClustersInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListClustersOutput struct {
	_ struct{} `type:"structure"`

	// Each ClusterListEntry object contains a cluster's state, a cluster's ID,
	// and other important status information.
	ClusterListEntries []ClusterListEntry `type:"list"`

	// HTTP requests are stateless. If you use the automatically generated NextToken
	// value in your next ClusterListEntry call, your list of returned clusters
	// will start from this point in the array.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListClustersOutput) String() string {
	return awsutil.Prettify(s)
}

const opListClusters = "ListClusters"

// ListClustersRequest returns a request value for making API operation for
// Amazon Import/Export Snowball.
//
// Returns an array of ClusterListEntry objects of the specified length. Each
// ClusterListEntry object contains a cluster's state, a cluster's ID, and other
// important status information.
//
//    // Example sending a request using ListClustersRequest.
//    req := client.ListClustersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListClusters
func (c *Client) ListClustersRequest(input *ListClustersInput) ListClustersRequest {
	op := &aws.Operation{
		Name:       opListClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListClustersInput{}
	}

	req := c.newRequest(op, input, &ListClustersOutput{})

	return ListClustersRequest{Request: req, Input: input, Copy: c.ListClustersRequest}
}

// ListClustersRequest is the request type for the
// ListClusters API operation.
type ListClustersRequest struct {
	*aws.Request
	Input *ListClustersInput
	Copy  func(*ListClustersInput) ListClustersRequest
}

// Send marshals and sends the ListClusters API request.
func (r ListClustersRequest) Send(ctx context.Context) (*ListClustersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListClustersResponse{
		ListClustersOutput: r.Request.Data.(*ListClustersOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListClustersResponse is the response type for the
// ListClusters API operation.
type ListClustersResponse struct {
	*ListClustersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListClusters request.
func (r *ListClustersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
