// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sns

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Input for SetTopicAttributes action.
type SetTopicAttributesInput struct {
	_ struct{} `type:"structure"`

	// A map of attributes with their corresponding values.
	//
	// The following lists the names, descriptions, and values of the special request
	// parameters that the SetTopicAttributes action uses:
	//
	//    * DeliveryPolicy – The policy that defines how Amazon SNS retries failed
	//    deliveries to HTTP/S endpoints.
	//
	//    * DisplayName – The display name to use for a topic with SMS subscriptions.
	//
	//    * Policy – The policy that defines who can access your topic. By default,
	//    only the topic owner can publish or subscribe to the topic.
	//
	// The following attribute applies only to server-side-encryption (https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html):
	//
	//    * KmsMasterKeyId – The ID of an AWS-managed customer master key (CMK)
	//    for Amazon SNS or a custom CMK. For more information, see Key Terms (https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms).
	//    For more examples, see KeyId (https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters)
	//    in the AWS Key Management Service API Reference.
	//
	// The following attribute applies only to FIFO topics:
	//
	//    * ContentBasedDeduplication – Enables content-based deduplication. Amazon
	//    SNS uses a SHA-256 hash to generate the MessageDeduplicationId using the
	//    body of the message (but not the attributes of the message).
	//
	//    * When ContentBasedDeduplication is in effect, messages with identical
	//    content sent within the deduplication interval are treated as duplicates
	//    and only one copy of the message is delivered.
	//
	//    * If the queue has ContentBasedDeduplication set, your MessageDeduplicationId
	//    overrides the generated one.
	//
	// AttributeName is a required field
	AttributeName *string `type:"string" required:"true"`

	// The new value for the attribute.
	AttributeValue *string `type:"string"`

	// The ARN of the topic to modify.
	//
	// TopicArn is a required field
	TopicArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SetTopicAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetTopicAttributesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetTopicAttributesInput"}

	if s.AttributeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AttributeName"))
	}

	if s.TopicArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("TopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SetTopicAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetTopicAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

const opSetTopicAttributes = "SetTopicAttributes"

// SetTopicAttributesRequest returns a request value for making API operation for
// Amazon Simple Notification Service.
//
// Allows a topic owner to set an attribute of the topic to a new value.
//
//    // Example sending a request using SetTopicAttributesRequest.
//    req := client.SetTopicAttributesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetTopicAttributes
func (c *Client) SetTopicAttributesRequest(input *SetTopicAttributesInput) SetTopicAttributesRequest {
	op := &aws.Operation{
		Name:       opSetTopicAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetTopicAttributesInput{}
	}

	req := c.newRequest(op, input, &SetTopicAttributesOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return SetTopicAttributesRequest{Request: req, Input: input, Copy: c.SetTopicAttributesRequest}
}

// SetTopicAttributesRequest is the request type for the
// SetTopicAttributes API operation.
type SetTopicAttributesRequest struct {
	*aws.Request
	Input *SetTopicAttributesInput
	Copy  func(*SetTopicAttributesInput) SetTopicAttributesRequest
}

// Send marshals and sends the SetTopicAttributes API request.
func (r SetTopicAttributesRequest) Send(ctx context.Context) (*SetTopicAttributesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SetTopicAttributesResponse{
		SetTopicAttributesOutput: r.Request.Data.(*SetTopicAttributesOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SetTopicAttributesResponse is the response type for the
// SetTopicAttributes API operation.
type SetTopicAttributesResponse struct {
	*SetTopicAttributesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SetTopicAttributes request.
func (r *SetTopicAttributesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
