// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sqs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListDeadLetterSourceQueuesInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to include in the response.
	MaxResults *int64 `type:"integer"`

	// Pagination token to request the next set of results.
	NextToken *string `type:"string"`

	// The URL of a dead-letter queue.
	//
	// Queue URLs and names are case-sensitive.
	//
	// QueueUrl is a required field
	QueueUrl *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListDeadLetterSourceQueuesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeadLetterSourceQueuesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListDeadLetterSourceQueuesInput"}

	if s.QueueUrl == nil {
		invalidParams.Add(aws.NewErrParamRequired("QueueUrl"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A list of your dead letter source queues.
type ListDeadLetterSourceQueuesOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token to include in the next request.
	NextToken *string `type:"string"`

	// A list of source queue URLs that have the RedrivePolicy queue attribute configured
	// with a dead-letter queue.
	//
	// QueueUrls is a required field
	QueueUrls []string `locationName:"queueUrls" locationNameList:"QueueUrl" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s ListDeadLetterSourceQueuesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListDeadLetterSourceQueues = "ListDeadLetterSourceQueues"

// ListDeadLetterSourceQueuesRequest returns a request value for making API operation for
// Amazon Simple Queue Service.
//
// Returns a list of your queues that have the RedrivePolicy queue attribute
// configured with a dead-letter queue.
//
// For more information about using dead-letter queues, see Using Amazon SQS
// Dead-Letter Queues (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html)
// in the Amazon Simple Queue Service Developer Guide.
//
//    // Example sending a request using ListDeadLetterSourceQueuesRequest.
//    req := client.ListDeadLetterSourceQueuesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sqs-2012-11-05/ListDeadLetterSourceQueues
func (c *Client) ListDeadLetterSourceQueuesRequest(input *ListDeadLetterSourceQueuesInput) ListDeadLetterSourceQueuesRequest {
	op := &aws.Operation{
		Name:       opListDeadLetterSourceQueues,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeadLetterSourceQueuesInput{}
	}

	req := c.newRequest(op, input, &ListDeadLetterSourceQueuesOutput{})

	return ListDeadLetterSourceQueuesRequest{Request: req, Input: input, Copy: c.ListDeadLetterSourceQueuesRequest}
}

// ListDeadLetterSourceQueuesRequest is the request type for the
// ListDeadLetterSourceQueues API operation.
type ListDeadLetterSourceQueuesRequest struct {
	*aws.Request
	Input *ListDeadLetterSourceQueuesInput
	Copy  func(*ListDeadLetterSourceQueuesInput) ListDeadLetterSourceQueuesRequest
}

// Send marshals and sends the ListDeadLetterSourceQueues API request.
func (r ListDeadLetterSourceQueuesRequest) Send(ctx context.Context) (*ListDeadLetterSourceQueuesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListDeadLetterSourceQueuesResponse{
		ListDeadLetterSourceQueuesOutput: r.Request.Data.(*ListDeadLetterSourceQueuesOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListDeadLetterSourceQueuesRequestPaginator returns a paginator for ListDeadLetterSourceQueues.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListDeadLetterSourceQueuesRequest(input)
//   p := sqs.NewListDeadLetterSourceQueuesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListDeadLetterSourceQueuesPaginator(req ListDeadLetterSourceQueuesRequest) ListDeadLetterSourceQueuesPaginator {
	return ListDeadLetterSourceQueuesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListDeadLetterSourceQueuesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListDeadLetterSourceQueuesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListDeadLetterSourceQueuesPaginator struct {
	aws.Pager
}

func (p *ListDeadLetterSourceQueuesPaginator) CurrentPage() *ListDeadLetterSourceQueuesOutput {
	return p.Pager.CurrentPage().(*ListDeadLetterSourceQueuesOutput)
}

// ListDeadLetterSourceQueuesResponse is the response type for the
// ListDeadLetterSourceQueues API operation.
type ListDeadLetterSourceQueuesResponse struct {
	*ListDeadLetterSourceQueuesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListDeadLetterSourceQueues request.
func (r *ListDeadLetterSourceQueuesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
