// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateActivationInput struct {
	_ struct{} `type:"structure"`

	// The name of the registered, managed instance as it will appear in the Systems
	// Manager console or when you use the AWS command line tools to list Systems
	// Manager resources.
	//
	// Do not enter personally identifiable information in this field.
	DefaultInstanceName *string `type:"string"`

	// A user-defined description of the resource that you want to register with
	// Systems Manager.
	//
	// Do not enter personally identifiable information in this field.
	Description *string `type:"string"`

	// The date by which this activation request should expire. The default value
	// is 24 hours.
	ExpirationDate *time.Time `type:"timestamp"`

	// The Amazon Identity and Access Management (IAM) role that you want to assign
	// to the managed instance. This IAM role must provide AssumeRole permissions
	// for the Systems Manager service principal ssm.amazonaws.com. For more information,
	// see Create an IAM service role for a hybrid environment (https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-service-role.html)
	// in the AWS Systems Manager User Guide.
	//
	// IamRole is a required field
	IamRole *string `type:"string" required:"true"`

	// Specify the maximum number of managed instances you want to register. The
	// default value is 1 instance.
	RegistrationLimit *int64 `min:"1" type:"integer"`

	// Optional metadata that you assign to a resource. Tags enable you to categorize
	// a resource in different ways, such as by purpose, owner, or environment.
	// For example, you might want to tag an activation to identify which servers
	// or virtual machines (VMs) in your on-premises environment you intend to activate.
	// In this case, you could specify the following key name/value pairs:
	//
	//    * Key=OS,Value=Windows
	//
	//    * Key=Environment,Value=Production
	//
	// When you install SSM Agent on your on-premises servers and VMs, you specify
	// an activation ID and code. When you specify the activation ID and code, tags
	// assigned to the activation are automatically applied to the on-premises servers
	// or VMs.
	//
	// You can't add tags to or delete tags from an existing activation. You can
	// tag your on-premises servers and VMs after they connect to Systems Manager
	// for the first time and are assigned a managed instance ID. This means they
	// are listed in the AWS Systems Manager console with an ID that is prefixed
	// with "mi-". For information about how to add tags to your managed instances,
	// see AddTagsToResource. For information about how to remove tags from your
	// managed instances, see RemoveTagsFromResource.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s CreateActivationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateActivationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateActivationInput"}

	if s.IamRole == nil {
		invalidParams.Add(aws.NewErrParamRequired("IamRole"))
	}
	if s.RegistrationLimit != nil && *s.RegistrationLimit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("RegistrationLimit", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateActivationOutput struct {
	_ struct{} `type:"structure"`

	// The code the system generates when it processes the activation. The activation
	// code functions like a password to validate the activation ID.
	ActivationCode *string `min:"20" type:"string"`

	// The ID number generated by the system when it processed the activation. The
	// activation ID functions like a user name.
	ActivationId *string `type:"string"`
}

// String returns the string representation
func (s CreateActivationOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateActivation = "CreateActivation"

// CreateActivationRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Generates an activation code and activation ID you can use to register your
// on-premises server or virtual machine (VM) with Systems Manager. Registering
// these machines with Systems Manager makes it possible to manage them using
// Systems Manager capabilities. You use the activation code and ID when installing
// SSM Agent on machines in your hybrid environment. For more information about
// requirements for managing on-premises instances and VMs using Systems Manager,
// see Setting up AWS Systems Manager for hybrid environments (https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances.html)
// in the AWS Systems Manager User Guide.
//
// On-premises servers or VMs that are registered with Systems Manager and EC2
// instances that you manage with Systems Manager are all called managed instances.
//
//    // Example sending a request using CreateActivationRequest.
//    req := client.CreateActivationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateActivation
func (c *Client) CreateActivationRequest(input *CreateActivationInput) CreateActivationRequest {
	op := &aws.Operation{
		Name:       opCreateActivation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateActivationInput{}
	}

	req := c.newRequest(op, input, &CreateActivationOutput{})

	return CreateActivationRequest{Request: req, Input: input, Copy: c.CreateActivationRequest}
}

// CreateActivationRequest is the request type for the
// CreateActivation API operation.
type CreateActivationRequest struct {
	*aws.Request
	Input *CreateActivationInput
	Copy  func(*CreateActivationInput) CreateActivationRequest
}

// Send marshals and sends the CreateActivation API request.
func (r CreateActivationRequest) Send(ctx context.Context) (*CreateActivationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateActivationResponse{
		CreateActivationOutput: r.Request.Data.(*CreateActivationOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateActivationResponse is the response type for the
// CreateActivation API operation.
type CreateActivationResponse struct {
	*CreateActivationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateActivation request.
func (r *CreateActivationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
