// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteResourceDataSyncInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration to delete.
	//
	// SyncName is a required field
	SyncName *string `min:"1" type:"string" required:"true"`

	// Specify the type of resource data sync to delete.
	SyncType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteResourceDataSyncInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourceDataSyncInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteResourceDataSyncInput"}

	if s.SyncName == nil {
		invalidParams.Add(aws.NewErrParamRequired("SyncName"))
	}
	if s.SyncName != nil && len(*s.SyncName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SyncName", 1))
	}
	if s.SyncType != nil && len(*s.SyncType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SyncType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteResourceDataSyncOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteResourceDataSyncOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteResourceDataSync = "DeleteResourceDataSync"

// DeleteResourceDataSyncRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Deletes a Resource Data Sync configuration. After the configuration is deleted,
// changes to data on managed instances are no longer synced to or from the
// target. Deleting a sync configuration does not delete data.
//
//    // Example sending a request using DeleteResourceDataSyncRequest.
//    req := client.DeleteResourceDataSyncRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteResourceDataSync
func (c *Client) DeleteResourceDataSyncRequest(input *DeleteResourceDataSyncInput) DeleteResourceDataSyncRequest {
	op := &aws.Operation{
		Name:       opDeleteResourceDataSync,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResourceDataSyncInput{}
	}

	req := c.newRequest(op, input, &DeleteResourceDataSyncOutput{})

	return DeleteResourceDataSyncRequest{Request: req, Input: input, Copy: c.DeleteResourceDataSyncRequest}
}

// DeleteResourceDataSyncRequest is the request type for the
// DeleteResourceDataSync API operation.
type DeleteResourceDataSyncRequest struct {
	*aws.Request
	Input *DeleteResourceDataSyncInput
	Copy  func(*DeleteResourceDataSyncInput) DeleteResourceDataSyncRequest
}

// Send marshals and sends the DeleteResourceDataSync API request.
func (r DeleteResourceDataSyncRequest) Send(ctx context.Context) (*DeleteResourceDataSyncResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteResourceDataSyncResponse{
		DeleteResourceDataSyncOutput: r.Request.Data.(*DeleteResourceDataSyncOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteResourceDataSyncResponse is the response type for the
// DeleteResourceDataSync API operation.
type DeleteResourceDataSyncResponse struct {
	*DeleteResourceDataSyncOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteResourceDataSync request.
func (r *DeleteResourceDataSyncResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
