// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeregisterPatchBaselineForPatchGroupInput struct {
	_ struct{} `type:"structure"`

	// The ID of the patch baseline to deregister the patch group from.
	//
	// BaselineId is a required field
	BaselineId *string `min:"20" type:"string" required:"true"`

	// The name of the patch group that should be deregistered from the patch baseline.
	//
	// PatchGroup is a required field
	PatchGroup *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterPatchBaselineForPatchGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterPatchBaselineForPatchGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeregisterPatchBaselineForPatchGroupInput"}

	if s.BaselineId == nil {
		invalidParams.Add(aws.NewErrParamRequired("BaselineId"))
	}
	if s.BaselineId != nil && len(*s.BaselineId) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("BaselineId", 20))
	}

	if s.PatchGroup == nil {
		invalidParams.Add(aws.NewErrParamRequired("PatchGroup"))
	}
	if s.PatchGroup != nil && len(*s.PatchGroup) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PatchGroup", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeregisterPatchBaselineForPatchGroupOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the patch baseline the patch group was deregistered from.
	BaselineId *string `min:"20" type:"string"`

	// The name of the patch group deregistered from the patch baseline.
	PatchGroup *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeregisterPatchBaselineForPatchGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeregisterPatchBaselineForPatchGroup = "DeregisterPatchBaselineForPatchGroup"

// DeregisterPatchBaselineForPatchGroupRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Removes a patch group from a patch baseline.
//
//    // Example sending a request using DeregisterPatchBaselineForPatchGroupRequest.
//    req := client.DeregisterPatchBaselineForPatchGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterPatchBaselineForPatchGroup
func (c *Client) DeregisterPatchBaselineForPatchGroupRequest(input *DeregisterPatchBaselineForPatchGroupInput) DeregisterPatchBaselineForPatchGroupRequest {
	op := &aws.Operation{
		Name:       opDeregisterPatchBaselineForPatchGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterPatchBaselineForPatchGroupInput{}
	}

	req := c.newRequest(op, input, &DeregisterPatchBaselineForPatchGroupOutput{})

	return DeregisterPatchBaselineForPatchGroupRequest{Request: req, Input: input, Copy: c.DeregisterPatchBaselineForPatchGroupRequest}
}

// DeregisterPatchBaselineForPatchGroupRequest is the request type for the
// DeregisterPatchBaselineForPatchGroup API operation.
type DeregisterPatchBaselineForPatchGroupRequest struct {
	*aws.Request
	Input *DeregisterPatchBaselineForPatchGroupInput
	Copy  func(*DeregisterPatchBaselineForPatchGroupInput) DeregisterPatchBaselineForPatchGroupRequest
}

// Send marshals and sends the DeregisterPatchBaselineForPatchGroup API request.
func (r DeregisterPatchBaselineForPatchGroupRequest) Send(ctx context.Context) (*DeregisterPatchBaselineForPatchGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeregisterPatchBaselineForPatchGroupResponse{
		DeregisterPatchBaselineForPatchGroupOutput: r.Request.Data.(*DeregisterPatchBaselineForPatchGroupOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeregisterPatchBaselineForPatchGroupResponse is the response type for the
// DeregisterPatchBaselineForPatchGroup API operation.
type DeregisterPatchBaselineForPatchGroupResponse struct {
	*DeregisterPatchBaselineForPatchGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeregisterPatchBaselineForPatchGroup request.
func (r *DeregisterPatchBaselineForPatchGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
