// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeDocumentPermissionInput struct {
	_ struct{} `type:"structure"`

	// The name of the document for which you are the owner.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The permission type for the document. The permission type can be Share.
	//
	// PermissionType is a required field
	PermissionType DocumentPermissionType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s DescribeDocumentPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDocumentPermissionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeDocumentPermissionInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if len(s.PermissionType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("PermissionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeDocumentPermissionOutput struct {
	_ struct{} `type:"structure"`

	// The account IDs that have permission to use this document. The ID can be
	// either an AWS account or All.
	AccountIds []string `type:"list"`

	// A list of AWS accounts where the current document is shared and the version
	// shared with each account.
	AccountSharingInfoList []AccountSharingInfo `type:"list"`
}

// String returns the string representation
func (s DescribeDocumentPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeDocumentPermission = "DescribeDocumentPermission"

// DescribeDocumentPermissionRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Describes the permissions for a Systems Manager document. If you created
// the document, you are the owner. If a document is shared, it can either be
// shared privately (by specifying a user's AWS account ID) or publicly (All).
//
//    // Example sending a request using DescribeDocumentPermissionRequest.
//    req := client.DescribeDocumentPermissionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocumentPermission
func (c *Client) DescribeDocumentPermissionRequest(input *DescribeDocumentPermissionInput) DescribeDocumentPermissionRequest {
	op := &aws.Operation{
		Name:       opDescribeDocumentPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDocumentPermissionInput{}
	}

	req := c.newRequest(op, input, &DescribeDocumentPermissionOutput{})

	return DescribeDocumentPermissionRequest{Request: req, Input: input, Copy: c.DescribeDocumentPermissionRequest}
}

// DescribeDocumentPermissionRequest is the request type for the
// DescribeDocumentPermission API operation.
type DescribeDocumentPermissionRequest struct {
	*aws.Request
	Input *DescribeDocumentPermissionInput
	Copy  func(*DescribeDocumentPermissionInput) DescribeDocumentPermissionRequest
}

// Send marshals and sends the DescribeDocumentPermission API request.
func (r DescribeDocumentPermissionRequest) Send(ctx context.Context) (*DescribeDocumentPermissionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDocumentPermissionResponse{
		DescribeDocumentPermissionOutput: r.Request.Data.(*DescribeDocumentPermissionOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDocumentPermissionResponse is the response type for the
// DescribeDocumentPermission API operation.
type DescribeDocumentPermissionResponse struct {
	*DescribeDocumentPermissionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDocumentPermission request.
func (r *DescribeDocumentPermissionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
