// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribePatchGroupStateInput struct {
	_ struct{} `type:"structure"`

	// The name of the patch group whose patch snapshot should be retrieved.
	//
	// PatchGroup is a required field
	PatchGroup *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribePatchGroupStateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePatchGroupStateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribePatchGroupStateInput"}

	if s.PatchGroup == nil {
		invalidParams.Add(aws.NewErrParamRequired("PatchGroup"))
	}
	if s.PatchGroup != nil && len(*s.PatchGroup) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PatchGroup", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribePatchGroupStateOutput struct {
	_ struct{} `type:"structure"`

	// The number of instances in the patch group.
	Instances *int64 `type:"integer"`

	// The number of instances with patches from the patch baseline that failed
	// to install.
	InstancesWithFailedPatches *int64 `type:"integer"`

	// The number of instances with patches installed that aren't defined in the
	// patch baseline.
	InstancesWithInstalledOtherPatches *int64 `type:"integer"`

	// The number of instances with installed patches.
	InstancesWithInstalledPatches *int64 `type:"integer"`

	// The number of instances with patches installed by Patch Manager that have
	// not been rebooted after the patch installation. The status of these instances
	// is NON_COMPLIANT.
	InstancesWithInstalledPendingRebootPatches *int64 `type:"integer"`

	// The number of instances with patches installed that are specified in a RejectedPatches
	// list. Patches with a status of INSTALLED_REJECTED were typically installed
	// before they were added to a RejectedPatches list.
	//
	// If ALLOW_AS_DEPENDENCY is the specified option for RejectedPatchesAction,
	// the value of InstancesWithInstalledRejectedPatches will always be 0 (zero).
	InstancesWithInstalledRejectedPatches *int64 `type:"integer"`

	// The number of instances with missing patches from the patch baseline.
	InstancesWithMissingPatches *int64 `type:"integer"`

	// The number of instances with patches that aren't applicable.
	InstancesWithNotApplicablePatches *int64 `type:"integer"`

	// The number of instances with NotApplicable patches beyond the supported limit,
	// which are not reported by name to Systems Manager Inventory.
	InstancesWithUnreportedNotApplicablePatches *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribePatchGroupStateOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribePatchGroupState = "DescribePatchGroupState"

// DescribePatchGroupStateRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Returns high-level aggregated patch compliance state for a patch group.
//
//    // Example sending a request using DescribePatchGroupStateRequest.
//    req := client.DescribePatchGroupStateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroupState
func (c *Client) DescribePatchGroupStateRequest(input *DescribePatchGroupStateInput) DescribePatchGroupStateRequest {
	op := &aws.Operation{
		Name:       opDescribePatchGroupState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePatchGroupStateInput{}
	}

	req := c.newRequest(op, input, &DescribePatchGroupStateOutput{})

	return DescribePatchGroupStateRequest{Request: req, Input: input, Copy: c.DescribePatchGroupStateRequest}
}

// DescribePatchGroupStateRequest is the request type for the
// DescribePatchGroupState API operation.
type DescribePatchGroupStateRequest struct {
	*aws.Request
	Input *DescribePatchGroupStateInput
	Copy  func(*DescribePatchGroupStateInput) DescribePatchGroupStateRequest
}

// Send marshals and sends the DescribePatchGroupState API request.
func (r DescribePatchGroupStateRequest) Send(ctx context.Context) (*DescribePatchGroupStateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribePatchGroupStateResponse{
		DescribePatchGroupStateOutput: r.Request.Data.(*DescribePatchGroupStateOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribePatchGroupStateResponse is the response type for the
// DescribePatchGroupState API operation.
type DescribePatchGroupStateResponse struct {
	*DescribePatchGroupStateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribePatchGroupState request.
func (r *DescribePatchGroupStateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
