// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sso

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetRoleCredentialsInput struct {
	_ struct{} `type:"structure"`

	// The token issued by the CreateToken API call. For more information, see CreateToken
	// (https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/API_CreateToken.html)
	// in the AWS SSO OIDC API Reference Guide.
	//
	// AccessToken is a required field
	AccessToken *string `location:"header" locationName:"x-amz-sso_bearer_token" type:"string" required:"true" sensitive:"true"`

	// The identifier for the AWS account that is assigned to the user.
	//
	// AccountId is a required field
	AccountId *string `location:"querystring" locationName:"account_id" type:"string" required:"true"`

	// The friendly name of the role that is assigned to the user.
	//
	// RoleName is a required field
	RoleName *string `location:"querystring" locationName:"role_name" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRoleCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRoleCredentialsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetRoleCredentialsInput"}

	if s.AccessToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccessToken"))
	}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.RoleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetRoleCredentialsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccessToken != nil {
		v := *s.AccessToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-sso_bearer_token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "account_id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleName != nil {
		v := *s.RoleName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "role_name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetRoleCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// The credentials for the role that is assigned to the user.
	RoleCredentials *RoleCredentials `locationName:"roleCredentials" type:"structure"`
}

// String returns the string representation
func (s GetRoleCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetRoleCredentialsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.RoleCredentials != nil {
		v := s.RoleCredentials

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "roleCredentials", v, metadata)
	}
	return nil
}

const opGetRoleCredentials = "GetRoleCredentials"

// GetRoleCredentialsRequest returns a request value for making API operation for
// AWS Single Sign-On.
//
// Returns the STS short-term credentials for a given role name that is assigned
// to the user.
//
//    // Example sending a request using GetRoleCredentialsRequest.
//    req := client.GetRoleCredentialsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sso-2019-06-10/GetRoleCredentials
func (c *Client) GetRoleCredentialsRequest(input *GetRoleCredentialsInput) GetRoleCredentialsRequest {
	op := &aws.Operation{
		Name:       opGetRoleCredentials,
		HTTPMethod: "GET",
		HTTPPath:   "/federation/credentials",
	}

	if input == nil {
		input = &GetRoleCredentialsInput{}
	}

	req := c.newRequest(op, input, &GetRoleCredentialsOutput{})
	req.Config.Credentials = aws.AnonymousCredentials

	return GetRoleCredentialsRequest{Request: req, Input: input, Copy: c.GetRoleCredentialsRequest}
}

// GetRoleCredentialsRequest is the request type for the
// GetRoleCredentials API operation.
type GetRoleCredentialsRequest struct {
	*aws.Request
	Input *GetRoleCredentialsInput
	Copy  func(*GetRoleCredentialsInput) GetRoleCredentialsRequest
}

// Send marshals and sends the GetRoleCredentials API request.
func (r GetRoleCredentialsRequest) Send(ctx context.Context) (*GetRoleCredentialsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetRoleCredentialsResponse{
		GetRoleCredentialsOutput: r.Request.Data.(*GetRoleCredentialsOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetRoleCredentialsResponse is the response type for the
// GetRoleCredentials API operation.
type GetRoleCredentialsResponse struct {
	*GetRoleCredentialsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetRoleCredentials request.
func (r *GetRoleCredentialsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
