// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssooidc

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type RegisterClientInput struct {
	_ struct{} `type:"structure"`

	// The friendly name of the client.
	//
	// ClientName is a required field
	ClientName *string `locationName:"clientName" type:"string" required:"true"`

	// The type of client. The service supports only public as a client type. Anything
	// other than public will be rejected by the service.
	//
	// ClientType is a required field
	ClientType *string `locationName:"clientType" type:"string" required:"true"`

	// The list of scopes that are defined by the client. Upon authorization, this
	// list is used to restrict permissions when granting an access token.
	Scopes []string `locationName:"scopes" type:"list"`
}

// String returns the string representation
func (s RegisterClientInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterClientInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RegisterClientInput"}

	if s.ClientName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientName"))
	}

	if s.ClientType == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RegisterClientInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ClientName != nil {
		v := *s.ClientName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ClientType != nil {
		v := *s.ClientType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Scopes != nil {
		v := s.Scopes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "scopes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

type RegisterClientOutput struct {
	_ struct{} `type:"structure"`

	// The endpoint where the client can request authorization.
	AuthorizationEndpoint *string `locationName:"authorizationEndpoint" type:"string"`

	// The unique identifier string for each client. This client uses this identifier
	// to get authenticated by the service in subsequent calls.
	ClientId *string `locationName:"clientId" type:"string"`

	// Indicates the time at which the clientId and clientSecret were issued.
	ClientIdIssuedAt *int64 `locationName:"clientIdIssuedAt" type:"long"`

	// A secret string generated for the client. The client will use this string
	// to get authenticated by the service in subsequent calls.
	ClientSecret *string `locationName:"clientSecret" type:"string"`

	// Indicates the time at which the clientId and clientSecret will become invalid.
	ClientSecretExpiresAt *int64 `locationName:"clientSecretExpiresAt" type:"long"`

	// The endpoint where the client can get an access token.
	TokenEndpoint *string `locationName:"tokenEndpoint" type:"string"`
}

// String returns the string representation
func (s RegisterClientOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RegisterClientOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AuthorizationEndpoint != nil {
		v := *s.AuthorizationEndpoint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizationEndpoint", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ClientId != nil {
		v := *s.ClientId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ClientIdIssuedAt != nil {
		v := *s.ClientIdIssuedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientIdIssuedAt", protocol.Int64Value(v), metadata)
	}
	if s.ClientSecret != nil {
		v := *s.ClientSecret

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientSecret", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ClientSecretExpiresAt != nil {
		v := *s.ClientSecretExpiresAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientSecretExpiresAt", protocol.Int64Value(v), metadata)
	}
	if s.TokenEndpoint != nil {
		v := *s.TokenEndpoint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "tokenEndpoint", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opRegisterClient = "RegisterClient"

// RegisterClientRequest returns a request value for making API operation for
// AWS SSO OIDC.
//
// Registers a client with AWS SSO. This allows clients to initiate device authorization.
// The output should be persisted for reuse through many authentication requests.
//
//    // Example sending a request using RegisterClientRequest.
//    req := client.RegisterClientRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sso-oidc-2019-06-10/RegisterClient
func (c *Client) RegisterClientRequest(input *RegisterClientInput) RegisterClientRequest {
	op := &aws.Operation{
		Name:       opRegisterClient,
		HTTPMethod: "POST",
		HTTPPath:   "/client/register",
	}

	if input == nil {
		input = &RegisterClientInput{}
	}

	req := c.newRequest(op, input, &RegisterClientOutput{})
	req.Config.Credentials = aws.AnonymousCredentials

	return RegisterClientRequest{Request: req, Input: input, Copy: c.RegisterClientRequest}
}

// RegisterClientRequest is the request type for the
// RegisterClient API operation.
type RegisterClientRequest struct {
	*aws.Request
	Input *RegisterClientInput
	Copy  func(*RegisterClientInput) RegisterClientRequest
}

// Send marshals and sends the RegisterClient API request.
func (r RegisterClientRequest) Send(ctx context.Context) (*RegisterClientResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RegisterClientResponse{
		RegisterClientOutput: r.Request.Data.(*RegisterClientOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RegisterClientResponse is the response type for the
// RegisterClient API operation.
type RegisterClientResponse struct {
	*RegisterClientOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RegisterClient request.
func (r *RegisterClientResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
