// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type AddUploadBufferInput struct {
	_ struct{} `type:"structure"`

	// An array of strings that identify disks that are to be configured as working
	// storage. Each string has a minimum length of 1 and maximum length of 300.
	// You can get the disk IDs from the ListLocalDisks API.
	//
	// DiskIds is a required field
	DiskIds []string `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s AddUploadBufferInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddUploadBufferInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AddUploadBufferInput"}

	if s.DiskIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("DiskIds"))
	}

	if s.GatewayARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(aws.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AddUploadBufferOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s AddUploadBufferOutput) String() string {
	return awsutil.Prettify(s)
}

const opAddUploadBuffer = "AddUploadBuffer"

// AddUploadBufferRequest returns a request value for making API operation for
// AWS Storage Gateway.
//
// Configures one or more gateway local disks as upload buffer for a specified
// gateway. This operation is supported for the stored volume, cached volume
// and tape gateway types.
//
// In the request, you specify the gateway Amazon Resource Name (ARN) to which
// you want to add upload buffer, and one or more disk IDs that you want to
// configure as upload buffer.
//
//    // Example sending a request using AddUploadBufferRequest.
//    req := client.AddUploadBufferRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddUploadBuffer
func (c *Client) AddUploadBufferRequest(input *AddUploadBufferInput) AddUploadBufferRequest {
	op := &aws.Operation{
		Name:       opAddUploadBuffer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddUploadBufferInput{}
	}

	req := c.newRequest(op, input, &AddUploadBufferOutput{})

	return AddUploadBufferRequest{Request: req, Input: input, Copy: c.AddUploadBufferRequest}
}

// AddUploadBufferRequest is the request type for the
// AddUploadBuffer API operation.
type AddUploadBufferRequest struct {
	*aws.Request
	Input *AddUploadBufferInput
	Copy  func(*AddUploadBufferInput) AddUploadBufferRequest
}

// Send marshals and sends the AddUploadBuffer API request.
func (r AddUploadBufferRequest) Send(ctx context.Context) (*AddUploadBufferResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AddUploadBufferResponse{
		AddUploadBufferOutput: r.Request.Data.(*AddUploadBufferOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AddUploadBufferResponse is the response type for the
// AddUploadBuffer API operation.
type AddUploadBufferResponse struct {
	*AddUploadBufferOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AddUploadBuffer request.
func (r *AddUploadBufferResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
