// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// CreateTapeWithBarcodeInput
type CreateTapeWithBarcodeInput struct {
	_ struct{} `type:"structure"`

	// The unique Amazon Resource Name (ARN) that represents the gateway to associate
	// the virtual tape with. Use the ListGateways operation to return a list of
	// gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// Set to true to use Amazon S3 server-side encryption with your own AWS KMS
	// key, or false to use a key managed by Amazon S3. Optional.
	//
	// Valid Values: true | false
	KMSEncrypted *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
	// for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric
	// CMKs. This value can only be set when KMSEncrypted is true. Optional.
	KMSKey *string `min:"7" type:"string"`

	// The ID of the pool that you want to add your tape to for archiving. The tape
	// in this pool is archived in the S3 storage class that is associated with
	// the pool. When you use your backup application to eject the tape, the tape
	// is archived directly into the storage class (S3 Glacier or S3 Deep Archive)
	// that corresponds to the pool.
	//
	// Valid Values: GLACIER | DEEP_ARCHIVE
	PoolId *string `min:"1" type:"string"`

	// A list of up to 50 tags that can be assigned to a virtual tape that has a
	// barcode. Each tag is a key-value pair.
	//
	// Valid characters for key and value are letters, spaces, and numbers representable
	// in UTF-8 format, and the following special characters: + - = . _ : / @. The
	// maximum length of a tag's key is 128 characters, and the maximum length for
	// a tag's value is 256.
	Tags []Tag `type:"list"`

	// The barcode that you want to assign to the tape.
	//
	// Barcodes cannot be reused. This includes barcodes used for tapes that have
	// been deleted.
	//
	// TapeBarcode is a required field
	TapeBarcode *string `min:"7" type:"string" required:"true"`

	// The size, in bytes, of the virtual tape that you want to create.
	//
	// The size must be aligned by gigabyte (1024*1024*1024 bytes).
	//
	// TapeSizeInBytes is a required field
	TapeSizeInBytes *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s CreateTapeWithBarcodeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTapeWithBarcodeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateTapeWithBarcodeInput"}

	if s.GatewayARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(aws.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.KMSKey != nil && len(*s.KMSKey) < 7 {
		invalidParams.Add(aws.NewErrParamMinLen("KMSKey", 7))
	}
	if s.PoolId != nil && len(*s.PoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PoolId", 1))
	}

	if s.TapeBarcode == nil {
		invalidParams.Add(aws.NewErrParamRequired("TapeBarcode"))
	}
	if s.TapeBarcode != nil && len(*s.TapeBarcode) < 7 {
		invalidParams.Add(aws.NewErrParamMinLen("TapeBarcode", 7))
	}

	if s.TapeSizeInBytes == nil {
		invalidParams.Add(aws.NewErrParamRequired("TapeSizeInBytes"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// CreateTapeOutput
type CreateTapeWithBarcodeOutput struct {
	_ struct{} `type:"structure"`

	// A unique Amazon Resource Name (ARN) that represents the virtual tape that
	// was created.
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s CreateTapeWithBarcodeOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateTapeWithBarcode = "CreateTapeWithBarcode"

// CreateTapeWithBarcodeRequest returns a request value for making API operation for
// AWS Storage Gateway.
//
// Creates a virtual tape by using your own barcode. You write data to the virtual
// tape and then archive the tape. A barcode is unique and can not be reused
// if it has already been used on a tape. This applies to barcodes used on deleted
// tapes. This operation is only supported in the tape gateway type.
//
// Cache storage must be allocated to the gateway before you can create a virtual
// tape. Use the AddCache operation to add cache storage to a gateway.
//
//    // Example sending a request using CreateTapeWithBarcodeRequest.
//    req := client.CreateTapeWithBarcodeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapeWithBarcode
func (c *Client) CreateTapeWithBarcodeRequest(input *CreateTapeWithBarcodeInput) CreateTapeWithBarcodeRequest {
	op := &aws.Operation{
		Name:       opCreateTapeWithBarcode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTapeWithBarcodeInput{}
	}

	req := c.newRequest(op, input, &CreateTapeWithBarcodeOutput{})

	return CreateTapeWithBarcodeRequest{Request: req, Input: input, Copy: c.CreateTapeWithBarcodeRequest}
}

// CreateTapeWithBarcodeRequest is the request type for the
// CreateTapeWithBarcode API operation.
type CreateTapeWithBarcodeRequest struct {
	*aws.Request
	Input *CreateTapeWithBarcodeInput
	Copy  func(*CreateTapeWithBarcodeInput) CreateTapeWithBarcodeRequest
}

// Send marshals and sends the CreateTapeWithBarcode API request.
func (r CreateTapeWithBarcodeRequest) Send(ctx context.Context) (*CreateTapeWithBarcodeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateTapeWithBarcodeResponse{
		CreateTapeWithBarcodeOutput: r.Request.Data.(*CreateTapeWithBarcodeOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateTapeWithBarcodeResponse is the response type for the
// CreateTapeWithBarcode API operation.
type CreateTapeWithBarcodeResponse struct {
	*CreateTapeWithBarcodeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateTapeWithBarcode request.
func (r *CreateTapeWithBarcodeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
