// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteAutomaticTapeCreationPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAutomaticTapeCreationPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAutomaticTapeCreationPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteAutomaticTapeCreationPolicyInput"}

	if s.GatewayARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(aws.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteAutomaticTapeCreationPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteAutomaticTapeCreationPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteAutomaticTapeCreationPolicy = "DeleteAutomaticTapeCreationPolicy"

// DeleteAutomaticTapeCreationPolicyRequest returns a request value for making API operation for
// AWS Storage Gateway.
//
// Deletes the automatic tape creation policy of a gateway. If you delete this
// policy, new virtual tapes must be created manually. Use the Amazon Resource
// Name (ARN) of the gateway in your request to remove the policy.
//
//    // Example sending a request using DeleteAutomaticTapeCreationPolicyRequest.
//    req := client.DeleteAutomaticTapeCreationPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteAutomaticTapeCreationPolicy
func (c *Client) DeleteAutomaticTapeCreationPolicyRequest(input *DeleteAutomaticTapeCreationPolicyInput) DeleteAutomaticTapeCreationPolicyRequest {
	op := &aws.Operation{
		Name:       opDeleteAutomaticTapeCreationPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAutomaticTapeCreationPolicyInput{}
	}

	req := c.newRequest(op, input, &DeleteAutomaticTapeCreationPolicyOutput{})

	return DeleteAutomaticTapeCreationPolicyRequest{Request: req, Input: input, Copy: c.DeleteAutomaticTapeCreationPolicyRequest}
}

// DeleteAutomaticTapeCreationPolicyRequest is the request type for the
// DeleteAutomaticTapeCreationPolicy API operation.
type DeleteAutomaticTapeCreationPolicyRequest struct {
	*aws.Request
	Input *DeleteAutomaticTapeCreationPolicyInput
	Copy  func(*DeleteAutomaticTapeCreationPolicyInput) DeleteAutomaticTapeCreationPolicyRequest
}

// Send marshals and sends the DeleteAutomaticTapeCreationPolicy API request.
func (r DeleteAutomaticTapeCreationPolicyRequest) Send(ctx context.Context) (*DeleteAutomaticTapeCreationPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteAutomaticTapeCreationPolicyResponse{
		DeleteAutomaticTapeCreationPolicyOutput: r.Request.Data.(*DeleteAutomaticTapeCreationPolicyOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteAutomaticTapeCreationPolicyResponse is the response type for the
// DeleteAutomaticTapeCreationPolicy API operation.
type DeleteAutomaticTapeCreationPolicyResponse struct {
	*DeleteAutomaticTapeCreationPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteAutomaticTapeCreationPolicy request.
func (r *DeleteAutomaticTapeCreationPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
