// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// DescribeTapeArchivesInput
type DescribeTapeArchivesInput struct {
	_ struct{} `type:"structure"`

	// Specifies that the number of virtual tapes described be limited to the specified
	// number.
	Limit *int64 `min:"1" type:"integer"`

	// An opaque string that indicates the position at which to begin describing
	// virtual tapes.
	Marker *string `min:"1" type:"string"`

	// Specifies one or more unique Amazon Resource Names (ARNs) that represent
	// the virtual tapes you want to describe.
	TapeARNs []string `type:"list"`
}

// String returns the string representation
func (s DescribeTapeArchivesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTapeArchivesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeTapeArchivesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// DescribeTapeArchivesOutput
type DescribeTapeArchivesOutput struct {
	_ struct{} `type:"structure"`

	// An opaque string that indicates the position at which the virtual tapes that
	// were fetched for description ended. Use this marker in your next request
	// to fetch the next set of virtual tapes in the virtual tape shelf (VTS). If
	// there are no more virtual tapes to describe, this field does not appear in
	// the response.
	Marker *string `min:"1" type:"string"`

	// An array of virtual tape objects in the virtual tape shelf (VTS). The description
	// includes of the Amazon Resource Name (ARN) of the virtual tapes. The information
	// returned includes the Amazon Resource Names (ARNs) of the tapes, size of
	// the tapes, status of the tapes, progress of the description, and tape barcode.
	TapeArchives []TapeArchive `type:"list"`
}

// String returns the string representation
func (s DescribeTapeArchivesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeTapeArchives = "DescribeTapeArchives"

// DescribeTapeArchivesRequest returns a request value for making API operation for
// AWS Storage Gateway.
//
// Returns a description of specified virtual tapes in the virtual tape shelf
// (VTS). This operation is only supported in the tape gateway type.
//
// If a specific TapeARN is not specified, AWS Storage Gateway returns a description
// of all virtual tapes found in the VTS associated with your account.
//
//    // Example sending a request using DescribeTapeArchivesRequest.
//    req := client.DescribeTapeArchivesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeArchives
func (c *Client) DescribeTapeArchivesRequest(input *DescribeTapeArchivesInput) DescribeTapeArchivesRequest {
	op := &aws.Operation{
		Name:       opDescribeTapeArchives,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTapeArchivesInput{}
	}

	req := c.newRequest(op, input, &DescribeTapeArchivesOutput{})

	return DescribeTapeArchivesRequest{Request: req, Input: input, Copy: c.DescribeTapeArchivesRequest}
}

// DescribeTapeArchivesRequest is the request type for the
// DescribeTapeArchives API operation.
type DescribeTapeArchivesRequest struct {
	*aws.Request
	Input *DescribeTapeArchivesInput
	Copy  func(*DescribeTapeArchivesInput) DescribeTapeArchivesRequest
}

// Send marshals and sends the DescribeTapeArchives API request.
func (r DescribeTapeArchivesRequest) Send(ctx context.Context) (*DescribeTapeArchivesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeTapeArchivesResponse{
		DescribeTapeArchivesOutput: r.Request.Data.(*DescribeTapeArchivesOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeTapeArchivesRequestPaginator returns a paginator for DescribeTapeArchives.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeTapeArchivesRequest(input)
//   p := storagegateway.NewDescribeTapeArchivesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeTapeArchivesPaginator(req DescribeTapeArchivesRequest) DescribeTapeArchivesPaginator {
	return DescribeTapeArchivesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeTapeArchivesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeTapeArchivesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeTapeArchivesPaginator struct {
	aws.Pager
}

func (p *DescribeTapeArchivesPaginator) CurrentPage() *DescribeTapeArchivesOutput {
	return p.Pager.CurrentPage().(*DescribeTapeArchivesOutput)
}

// DescribeTapeArchivesResponse is the response type for the
// DescribeTapeArchives API operation.
type DescribeTapeArchivesResponse struct {
	*DescribeTapeArchivesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTapeArchives request.
func (r *DescribeTapeArchivesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
