// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// DescribeTapesInput
type DescribeTapesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// Specifies that the number of virtual tapes described be limited to the specified
	// number.
	//
	// Amazon Web Services may impose its own limit, if this field is not set.
	Limit *int64 `min:"1" type:"integer"`

	// A marker value, obtained in a previous call to DescribeTapes. This marker
	// indicates which page of results to retrieve.
	//
	// If not specified, the first page of results is retrieved.
	Marker *string `min:"1" type:"string"`

	// Specifies one or more unique Amazon Resource Names (ARNs) that represent
	// the virtual tapes you want to describe. If this parameter is not specified,
	// Tape gateway returns a description of all virtual tapes associated with the
	// specified gateway.
	TapeARNs []string `type:"list"`
}

// String returns the string representation
func (s DescribeTapesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTapesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeTapesInput"}

	if s.GatewayARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(aws.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// DescribeTapesOutput
type DescribeTapesOutput struct {
	_ struct{} `type:"structure"`

	// An opaque string which can be used as part of a subsequent DescribeTapes
	// call to retrieve the next page of results.
	//
	// If a response does not contain a marker, then there are no more results to
	// be retrieved.
	Marker *string `min:"1" type:"string"`

	// An array of virtual tape descriptions.
	Tapes []Tape `type:"list"`
}

// String returns the string representation
func (s DescribeTapesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeTapes = "DescribeTapes"

// DescribeTapesRequest returns a request value for making API operation for
// AWS Storage Gateway.
//
// Returns a description of the specified Amazon Resource Name (ARN) of virtual
// tapes. If a TapeARN is not specified, returns a description of all virtual
// tapes associated with the specified gateway. This operation is only supported
// in the tape gateway type.
//
//    // Example sending a request using DescribeTapesRequest.
//    req := client.DescribeTapesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapes
func (c *Client) DescribeTapesRequest(input *DescribeTapesInput) DescribeTapesRequest {
	op := &aws.Operation{
		Name:       opDescribeTapes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTapesInput{}
	}

	req := c.newRequest(op, input, &DescribeTapesOutput{})

	return DescribeTapesRequest{Request: req, Input: input, Copy: c.DescribeTapesRequest}
}

// DescribeTapesRequest is the request type for the
// DescribeTapes API operation.
type DescribeTapesRequest struct {
	*aws.Request
	Input *DescribeTapesInput
	Copy  func(*DescribeTapesInput) DescribeTapesRequest
}

// Send marshals and sends the DescribeTapes API request.
func (r DescribeTapesRequest) Send(ctx context.Context) (*DescribeTapesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeTapesResponse{
		DescribeTapesOutput: r.Request.Data.(*DescribeTapesOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeTapesRequestPaginator returns a paginator for DescribeTapes.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeTapesRequest(input)
//   p := storagegateway.NewDescribeTapesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeTapesPaginator(req DescribeTapesRequest) DescribeTapesPaginator {
	return DescribeTapesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeTapesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeTapesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeTapesPaginator struct {
	aws.Pager
}

func (p *DescribeTapesPaginator) CurrentPage() *DescribeTapesOutput {
	return p.Pager.CurrentPage().(*DescribeTapesOutput)
}

// DescribeTapesResponse is the response type for the
// DescribeTapes API operation.
type DescribeTapesResponse struct {
	*DescribeTapesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTapes request.
func (r *DescribeTapesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
