// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// RetrieveTapeArchiveInput
type RetrieveTapeArchiveInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway you want to retrieve the virtual
	// tape to. Use the ListGateways operation to return a list of gateways for
	// your account and AWS Region.
	//
	// You retrieve archived virtual tapes to only one gateway and the gateway must
	// be a tape gateway.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the virtual tape you want to retrieve from
	// the virtual tape shelf (VTS).
	//
	// TapeARN is a required field
	TapeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s RetrieveTapeArchiveInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrieveTapeArchiveInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RetrieveTapeArchiveInput"}

	if s.GatewayARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(aws.NewErrParamMinLen("GatewayARN", 50))
	}

	if s.TapeARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("TapeARN"))
	}
	if s.TapeARN != nil && len(*s.TapeARN) < 50 {
		invalidParams.Add(aws.NewErrParamMinLen("TapeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// RetrieveTapeArchiveOutput
type RetrieveTapeArchiveOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the retrieved virtual tape.
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s RetrieveTapeArchiveOutput) String() string {
	return awsutil.Prettify(s)
}

const opRetrieveTapeArchive = "RetrieveTapeArchive"

// RetrieveTapeArchiveRequest returns a request value for making API operation for
// AWS Storage Gateway.
//
// Retrieves an archived virtual tape from the virtual tape shelf (VTS) to a
// tape gateway. Virtual tapes archived in the VTS are not associated with any
// gateway. However after a tape is retrieved, it is associated with a gateway,
// even though it is also listed in the VTS, that is, archive. This operation
// is only supported in the tape gateway type.
//
// Once a tape is successfully retrieved to a gateway, it cannot be retrieved
// again to another gateway. You must archive the tape again before you can
// retrieve it to another gateway. This operation is only supported in the tape
// gateway type.
//
//    // Example sending a request using RetrieveTapeArchiveRequest.
//    req := client.RetrieveTapeArchiveRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RetrieveTapeArchive
func (c *Client) RetrieveTapeArchiveRequest(input *RetrieveTapeArchiveInput) RetrieveTapeArchiveRequest {
	op := &aws.Operation{
		Name:       opRetrieveTapeArchive,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RetrieveTapeArchiveInput{}
	}

	req := c.newRequest(op, input, &RetrieveTapeArchiveOutput{})

	return RetrieveTapeArchiveRequest{Request: req, Input: input, Copy: c.RetrieveTapeArchiveRequest}
}

// RetrieveTapeArchiveRequest is the request type for the
// RetrieveTapeArchive API operation.
type RetrieveTapeArchiveRequest struct {
	*aws.Request
	Input *RetrieveTapeArchiveInput
	Copy  func(*RetrieveTapeArchiveInput) RetrieveTapeArchiveRequest
}

// Send marshals and sends the RetrieveTapeArchive API request.
func (r RetrieveTapeArchiveRequest) Send(ctx context.Context) (*RetrieveTapeArchiveResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RetrieveTapeArchiveResponse{
		RetrieveTapeArchiveOutput: r.Request.Data.(*RetrieveTapeArchiveOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RetrieveTapeArchiveResponse is the response type for the
// RetrieveTapeArchive API operation.
type RetrieveTapeArchiveResponse struct {
	*RetrieveTapeArchiveOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RetrieveTapeArchive request.
func (r *RetrieveTapeArchiveResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
