// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// RetrieveTapeRecoveryPointInput
type RetrieveTapeRecoveryPointInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the virtual tape for which you want to
	// retrieve the recovery point.
	//
	// TapeARN is a required field
	TapeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s RetrieveTapeRecoveryPointInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrieveTapeRecoveryPointInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RetrieveTapeRecoveryPointInput"}

	if s.GatewayARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(aws.NewErrParamMinLen("GatewayARN", 50))
	}

	if s.TapeARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("TapeARN"))
	}
	if s.TapeARN != nil && len(*s.TapeARN) < 50 {
		invalidParams.Add(aws.NewErrParamMinLen("TapeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// RetrieveTapeRecoveryPointOutput
type RetrieveTapeRecoveryPointOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the virtual tape for which the recovery
	// point was retrieved.
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s RetrieveTapeRecoveryPointOutput) String() string {
	return awsutil.Prettify(s)
}

const opRetrieveTapeRecoveryPoint = "RetrieveTapeRecoveryPoint"

// RetrieveTapeRecoveryPointRequest returns a request value for making API operation for
// AWS Storage Gateway.
//
// Retrieves the recovery point for the specified virtual tape. This operation
// is only supported in the tape gateway type.
//
// A recovery point is a point in time view of a virtual tape at which all the
// data on the tape is consistent. If your gateway crashes, virtual tapes that
// have recovery points can be recovered to a new gateway.
//
// The virtual tape can be retrieved to only one gateway. The retrieved tape
// is read-only. The virtual tape can be retrieved to only a tape gateway. There
// is no charge for retrieving recovery points.
//
//    // Example sending a request using RetrieveTapeRecoveryPointRequest.
//    req := client.RetrieveTapeRecoveryPointRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RetrieveTapeRecoveryPoint
func (c *Client) RetrieveTapeRecoveryPointRequest(input *RetrieveTapeRecoveryPointInput) RetrieveTapeRecoveryPointRequest {
	op := &aws.Operation{
		Name:       opRetrieveTapeRecoveryPoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RetrieveTapeRecoveryPointInput{}
	}

	req := c.newRequest(op, input, &RetrieveTapeRecoveryPointOutput{})

	return RetrieveTapeRecoveryPointRequest{Request: req, Input: input, Copy: c.RetrieveTapeRecoveryPointRequest}
}

// RetrieveTapeRecoveryPointRequest is the request type for the
// RetrieveTapeRecoveryPoint API operation.
type RetrieveTapeRecoveryPointRequest struct {
	*aws.Request
	Input *RetrieveTapeRecoveryPointInput
	Copy  func(*RetrieveTapeRecoveryPointInput) RetrieveTapeRecoveryPointRequest
}

// Send marshals and sends the RetrieveTapeRecoveryPoint API request.
func (r RetrieveTapeRecoveryPointRequest) Send(ctx context.Context) (*RetrieveTapeRecoveryPointResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RetrieveTapeRecoveryPointResponse{
		RetrieveTapeRecoveryPointOutput: r.Request.Data.(*RetrieveTapeRecoveryPointOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RetrieveTapeRecoveryPointResponse is the response type for the
// RetrieveTapeRecoveryPoint API operation.
type RetrieveTapeRecoveryPointResponse struct {
	*RetrieveTapeRecoveryPointOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RetrieveTapeRecoveryPoint request.
func (r *RetrieveTapeRecoveryPointResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
