// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// A JSON object containing the Amazon Resource Name (ARN) of the gateway to
// shut down.
type ShutdownGatewayInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s ShutdownGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ShutdownGatewayInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ShutdownGatewayInput"}

	if s.GatewayARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(aws.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the Amazon Resource Name (ARN) of the gateway that
// was shut down.
type ShutdownGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s ShutdownGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

const opShutdownGateway = "ShutdownGateway"

// ShutdownGatewayRequest returns a request value for making API operation for
// AWS Storage Gateway.
//
// Shuts down a gateway. To specify which gateway to shut down, use the Amazon
// Resource Name (ARN) of the gateway in the body of your request.
//
// The operation shuts down the gateway service component running in the gateway's
// virtual machine (VM) and not the host VM.
//
// If you want to shut down the VM, it is recommended that you first shut down
// the gateway component in the VM to avoid unpredictable conditions.
//
// After the gateway is shutdown, you cannot call any other API except StartGateway,
// DescribeGatewayInformation, and ListGateways. For more information, see ActivateGateway.
// Your applications cannot read from or write to the gateway's storage volumes,
// and there are no snapshots taken.
//
// When you make a shutdown request, you will get a 200 OK success response
// immediately. However, it might take some time for the gateway to shut down.
// You can call the DescribeGatewayInformation API to check the status. For
// more information, see ActivateGateway.
//
// If do not intend to use the gateway again, you must delete the gateway (using
// DeleteGateway) to no longer pay software charges associated with the gateway.
//
//    // Example sending a request using ShutdownGatewayRequest.
//    req := client.ShutdownGatewayRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ShutdownGateway
func (c *Client) ShutdownGatewayRequest(input *ShutdownGatewayInput) ShutdownGatewayRequest {
	op := &aws.Operation{
		Name:       opShutdownGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ShutdownGatewayInput{}
	}

	req := c.newRequest(op, input, &ShutdownGatewayOutput{})

	return ShutdownGatewayRequest{Request: req, Input: input, Copy: c.ShutdownGatewayRequest}
}

// ShutdownGatewayRequest is the request type for the
// ShutdownGateway API operation.
type ShutdownGatewayRequest struct {
	*aws.Request
	Input *ShutdownGatewayInput
	Copy  func(*ShutdownGatewayInput) ShutdownGatewayRequest
}

// Send marshals and sends the ShutdownGateway API request.
func (r ShutdownGatewayRequest) Send(ctx context.Context) (*ShutdownGatewayResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ShutdownGatewayResponse{
		ShutdownGatewayOutput: r.Request.Data.(*ShutdownGatewayOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ShutdownGatewayResponse is the response type for the
// ShutdownGateway API operation.
type ShutdownGatewayResponse struct {
	*ShutdownGatewayOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ShutdownGateway request.
func (r *ShutdownGatewayResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
