// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package storagegatewayiface provides an interface to enable mocking the AWS Storage Gateway service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package storagegatewayiface

import (
	"github.com/aws/aws-sdk-go-v2/service/storagegateway"
)

// ClientAPI provides an interface to enable mocking the
// storagegateway.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS Storage Gateway.
//    func myFunc(svc storagegatewayiface.ClientAPI) bool {
//        // Make svc.ActivateGateway request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := storagegateway.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        storagegatewayiface.ClientPI
//    }
//    func (m *mockClientClient) ActivateGateway(input *storagegateway.ActivateGatewayInput) (*storagegateway.ActivateGatewayOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	ActivateGatewayRequest(*storagegateway.ActivateGatewayInput) storagegateway.ActivateGatewayRequest

	AddCacheRequest(*storagegateway.AddCacheInput) storagegateway.AddCacheRequest

	AddTagsToResourceRequest(*storagegateway.AddTagsToResourceInput) storagegateway.AddTagsToResourceRequest

	AddUploadBufferRequest(*storagegateway.AddUploadBufferInput) storagegateway.AddUploadBufferRequest

	AddWorkingStorageRequest(*storagegateway.AddWorkingStorageInput) storagegateway.AddWorkingStorageRequest

	AssignTapePoolRequest(*storagegateway.AssignTapePoolInput) storagegateway.AssignTapePoolRequest

	AttachVolumeRequest(*storagegateway.AttachVolumeInput) storagegateway.AttachVolumeRequest

	CancelArchivalRequest(*storagegateway.CancelArchivalInput) storagegateway.CancelArchivalRequest

	CancelRetrievalRequest(*storagegateway.CancelRetrievalInput) storagegateway.CancelRetrievalRequest

	CreateCachediSCSIVolumeRequest(*storagegateway.CreateCachediSCSIVolumeInput) storagegateway.CreateCachediSCSIVolumeRequest

	CreateNFSFileShareRequest(*storagegateway.CreateNFSFileShareInput) storagegateway.CreateNFSFileShareRequest

	CreateSMBFileShareRequest(*storagegateway.CreateSMBFileShareInput) storagegateway.CreateSMBFileShareRequest

	CreateSnapshotRequest(*storagegateway.CreateSnapshotInput) storagegateway.CreateSnapshotRequest

	CreateSnapshotFromVolumeRecoveryPointRequest(*storagegateway.CreateSnapshotFromVolumeRecoveryPointInput) storagegateway.CreateSnapshotFromVolumeRecoveryPointRequest

	CreateStorediSCSIVolumeRequest(*storagegateway.CreateStorediSCSIVolumeInput) storagegateway.CreateStorediSCSIVolumeRequest

	CreateTapeWithBarcodeRequest(*storagegateway.CreateTapeWithBarcodeInput) storagegateway.CreateTapeWithBarcodeRequest

	CreateTapesRequest(*storagegateway.CreateTapesInput) storagegateway.CreateTapesRequest

	DeleteAutomaticTapeCreationPolicyRequest(*storagegateway.DeleteAutomaticTapeCreationPolicyInput) storagegateway.DeleteAutomaticTapeCreationPolicyRequest

	DeleteBandwidthRateLimitRequest(*storagegateway.DeleteBandwidthRateLimitInput) storagegateway.DeleteBandwidthRateLimitRequest

	DeleteChapCredentialsRequest(*storagegateway.DeleteChapCredentialsInput) storagegateway.DeleteChapCredentialsRequest

	DeleteFileShareRequest(*storagegateway.DeleteFileShareInput) storagegateway.DeleteFileShareRequest

	DeleteGatewayRequest(*storagegateway.DeleteGatewayInput) storagegateway.DeleteGatewayRequest

	DeleteSnapshotScheduleRequest(*storagegateway.DeleteSnapshotScheduleInput) storagegateway.DeleteSnapshotScheduleRequest

	DeleteTapeRequest(*storagegateway.DeleteTapeInput) storagegateway.DeleteTapeRequest

	DeleteTapeArchiveRequest(*storagegateway.DeleteTapeArchiveInput) storagegateway.DeleteTapeArchiveRequest

	DeleteVolumeRequest(*storagegateway.DeleteVolumeInput) storagegateway.DeleteVolumeRequest

	DescribeAvailabilityMonitorTestRequest(*storagegateway.DescribeAvailabilityMonitorTestInput) storagegateway.DescribeAvailabilityMonitorTestRequest

	DescribeBandwidthRateLimitRequest(*storagegateway.DescribeBandwidthRateLimitInput) storagegateway.DescribeBandwidthRateLimitRequest

	DescribeCacheRequest(*storagegateway.DescribeCacheInput) storagegateway.DescribeCacheRequest

	DescribeCachediSCSIVolumesRequest(*storagegateway.DescribeCachediSCSIVolumesInput) storagegateway.DescribeCachediSCSIVolumesRequest

	DescribeChapCredentialsRequest(*storagegateway.DescribeChapCredentialsInput) storagegateway.DescribeChapCredentialsRequest

	DescribeGatewayInformationRequest(*storagegateway.DescribeGatewayInformationInput) storagegateway.DescribeGatewayInformationRequest

	DescribeMaintenanceStartTimeRequest(*storagegateway.DescribeMaintenanceStartTimeInput) storagegateway.DescribeMaintenanceStartTimeRequest

	DescribeNFSFileSharesRequest(*storagegateway.DescribeNFSFileSharesInput) storagegateway.DescribeNFSFileSharesRequest

	DescribeSMBFileSharesRequest(*storagegateway.DescribeSMBFileSharesInput) storagegateway.DescribeSMBFileSharesRequest

	DescribeSMBSettingsRequest(*storagegateway.DescribeSMBSettingsInput) storagegateway.DescribeSMBSettingsRequest

	DescribeSnapshotScheduleRequest(*storagegateway.DescribeSnapshotScheduleInput) storagegateway.DescribeSnapshotScheduleRequest

	DescribeStorediSCSIVolumesRequest(*storagegateway.DescribeStorediSCSIVolumesInput) storagegateway.DescribeStorediSCSIVolumesRequest

	DescribeTapeArchivesRequest(*storagegateway.DescribeTapeArchivesInput) storagegateway.DescribeTapeArchivesRequest

	DescribeTapeRecoveryPointsRequest(*storagegateway.DescribeTapeRecoveryPointsInput) storagegateway.DescribeTapeRecoveryPointsRequest

	DescribeTapesRequest(*storagegateway.DescribeTapesInput) storagegateway.DescribeTapesRequest

	DescribeUploadBufferRequest(*storagegateway.DescribeUploadBufferInput) storagegateway.DescribeUploadBufferRequest

	DescribeVTLDevicesRequest(*storagegateway.DescribeVTLDevicesInput) storagegateway.DescribeVTLDevicesRequest

	DescribeWorkingStorageRequest(*storagegateway.DescribeWorkingStorageInput) storagegateway.DescribeWorkingStorageRequest

	DetachVolumeRequest(*storagegateway.DetachVolumeInput) storagegateway.DetachVolumeRequest

	DisableGatewayRequest(*storagegateway.DisableGatewayInput) storagegateway.DisableGatewayRequest

	JoinDomainRequest(*storagegateway.JoinDomainInput) storagegateway.JoinDomainRequest

	ListAutomaticTapeCreationPoliciesRequest(*storagegateway.ListAutomaticTapeCreationPoliciesInput) storagegateway.ListAutomaticTapeCreationPoliciesRequest

	ListFileSharesRequest(*storagegateway.ListFileSharesInput) storagegateway.ListFileSharesRequest

	ListGatewaysRequest(*storagegateway.ListGatewaysInput) storagegateway.ListGatewaysRequest

	ListLocalDisksRequest(*storagegateway.ListLocalDisksInput) storagegateway.ListLocalDisksRequest

	ListTagsForResourceRequest(*storagegateway.ListTagsForResourceInput) storagegateway.ListTagsForResourceRequest

	ListTapesRequest(*storagegateway.ListTapesInput) storagegateway.ListTapesRequest

	ListVolumeInitiatorsRequest(*storagegateway.ListVolumeInitiatorsInput) storagegateway.ListVolumeInitiatorsRequest

	ListVolumeRecoveryPointsRequest(*storagegateway.ListVolumeRecoveryPointsInput) storagegateway.ListVolumeRecoveryPointsRequest

	ListVolumesRequest(*storagegateway.ListVolumesInput) storagegateway.ListVolumesRequest

	NotifyWhenUploadedRequest(*storagegateway.NotifyWhenUploadedInput) storagegateway.NotifyWhenUploadedRequest

	RefreshCacheRequest(*storagegateway.RefreshCacheInput) storagegateway.RefreshCacheRequest

	RemoveTagsFromResourceRequest(*storagegateway.RemoveTagsFromResourceInput) storagegateway.RemoveTagsFromResourceRequest

	ResetCacheRequest(*storagegateway.ResetCacheInput) storagegateway.ResetCacheRequest

	RetrieveTapeArchiveRequest(*storagegateway.RetrieveTapeArchiveInput) storagegateway.RetrieveTapeArchiveRequest

	RetrieveTapeRecoveryPointRequest(*storagegateway.RetrieveTapeRecoveryPointInput) storagegateway.RetrieveTapeRecoveryPointRequest

	SetLocalConsolePasswordRequest(*storagegateway.SetLocalConsolePasswordInput) storagegateway.SetLocalConsolePasswordRequest

	SetSMBGuestPasswordRequest(*storagegateway.SetSMBGuestPasswordInput) storagegateway.SetSMBGuestPasswordRequest

	ShutdownGatewayRequest(*storagegateway.ShutdownGatewayInput) storagegateway.ShutdownGatewayRequest

	StartAvailabilityMonitorTestRequest(*storagegateway.StartAvailabilityMonitorTestInput) storagegateway.StartAvailabilityMonitorTestRequest

	StartGatewayRequest(*storagegateway.StartGatewayInput) storagegateway.StartGatewayRequest

	UpdateAutomaticTapeCreationPolicyRequest(*storagegateway.UpdateAutomaticTapeCreationPolicyInput) storagegateway.UpdateAutomaticTapeCreationPolicyRequest

	UpdateBandwidthRateLimitRequest(*storagegateway.UpdateBandwidthRateLimitInput) storagegateway.UpdateBandwidthRateLimitRequest

	UpdateChapCredentialsRequest(*storagegateway.UpdateChapCredentialsInput) storagegateway.UpdateChapCredentialsRequest

	UpdateGatewayInformationRequest(*storagegateway.UpdateGatewayInformationInput) storagegateway.UpdateGatewayInformationRequest

	UpdateGatewaySoftwareNowRequest(*storagegateway.UpdateGatewaySoftwareNowInput) storagegateway.UpdateGatewaySoftwareNowRequest

	UpdateMaintenanceStartTimeRequest(*storagegateway.UpdateMaintenanceStartTimeInput) storagegateway.UpdateMaintenanceStartTimeRequest

	UpdateNFSFileShareRequest(*storagegateway.UpdateNFSFileShareInput) storagegateway.UpdateNFSFileShareRequest

	UpdateSMBFileShareRequest(*storagegateway.UpdateSMBFileShareInput) storagegateway.UpdateSMBFileShareRequest

	UpdateSMBSecurityStrategyRequest(*storagegateway.UpdateSMBSecurityStrategyInput) storagegateway.UpdateSMBSecurityStrategyRequest

	UpdateSnapshotScheduleRequest(*storagegateway.UpdateSnapshotScheduleInput) storagegateway.UpdateSnapshotScheduleRequest

	UpdateVTLDeviceTypeRequest(*storagegateway.UpdateVTLDeviceTypeInput) storagegateway.UpdateVTLDeviceTypeRequest
}

var _ ClientAPI = (*storagegateway.Client)(nil)
