// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package support

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type AddAttachmentsToSetInput struct {
	_ struct{} `type:"structure"`

	// The ID of the attachment set. If an attachmentSetId is not specified, a new
	// attachment set is created, and the ID of the set is returned in the response.
	// If an attachmentSetId is specified, the attachments are added to the specified
	// set, if it exists.
	AttachmentSetId *string `locationName:"attachmentSetId" type:"string"`

	// One or more attachments to add to the set. You can add up to three attachments
	// per set. The size limit is 5 MB per attachment.
	//
	// In the Attachment object, use the data parameter to specify the contents
	// of the attachment file. In the previous request syntax, the value for data
	// appear as blob, which is represented as a base64-encoded string. The value
	// for fileName is the name of the attachment, such as troubleshoot-screenshot.png.
	//
	// Attachments is a required field
	Attachments []Attachment `locationName:"attachments" type:"list" required:"true"`
}

// String returns the string representation
func (s AddAttachmentsToSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddAttachmentsToSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AddAttachmentsToSetInput"}

	if s.Attachments == nil {
		invalidParams.Add(aws.NewErrParamRequired("Attachments"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The ID and expiry time of the attachment set returned by the AddAttachmentsToSet
// operation.
type AddAttachmentsToSetOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the attachment set. If an attachmentSetId was not specified, a
	// new attachment set is created, and the ID of the set is returned in the response.
	// If an attachmentSetId was specified, the attachments are added to the specified
	// set, if it exists.
	AttachmentSetId *string `locationName:"attachmentSetId" type:"string"`

	// The time and date when the attachment set expires.
	ExpiryTime *string `locationName:"expiryTime" type:"string"`
}

// String returns the string representation
func (s AddAttachmentsToSetOutput) String() string {
	return awsutil.Prettify(s)
}

const opAddAttachmentsToSet = "AddAttachmentsToSet"

// AddAttachmentsToSetRequest returns a request value for making API operation for
// AWS Support.
//
// Adds one or more attachments to an attachment set.
//
// An attachment set is a temporary container for attachments that you add to
// a case or case communication. The set is available for 1 hour after it's
// created. The expiryTime returned in the response is when the set expires.
//
//    * You must have a Business or Enterprise support plan to use the AWS Support
//    API.
//
//    * If you call the AWS Support API from an account that does not have a
//    Business or Enterprise support plan, the SubscriptionRequiredException
//    error message appears. For information about changing your support plan,
//    see AWS Support (http://aws.amazon.com/premiumsupport/).
//
//    // Example sending a request using AddAttachmentsToSetRequest.
//    req := client.AddAttachmentsToSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/AddAttachmentsToSet
func (c *Client) AddAttachmentsToSetRequest(input *AddAttachmentsToSetInput) AddAttachmentsToSetRequest {
	op := &aws.Operation{
		Name:       opAddAttachmentsToSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddAttachmentsToSetInput{}
	}

	req := c.newRequest(op, input, &AddAttachmentsToSetOutput{})

	return AddAttachmentsToSetRequest{Request: req, Input: input, Copy: c.AddAttachmentsToSetRequest}
}

// AddAttachmentsToSetRequest is the request type for the
// AddAttachmentsToSet API operation.
type AddAttachmentsToSetRequest struct {
	*aws.Request
	Input *AddAttachmentsToSetInput
	Copy  func(*AddAttachmentsToSetInput) AddAttachmentsToSetRequest
}

// Send marshals and sends the AddAttachmentsToSet API request.
func (r AddAttachmentsToSetRequest) Send(ctx context.Context) (*AddAttachmentsToSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AddAttachmentsToSetResponse{
		AddAttachmentsToSetOutput: r.Request.Data.(*AddAttachmentsToSetOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AddAttachmentsToSetResponse is the response type for the
// AddAttachmentsToSet API operation.
type AddAttachmentsToSetResponse struct {
	*AddAttachmentsToSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AddAttachmentsToSet request.
func (r *AddAttachmentsToSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
