// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package support

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ResolveCaseInput struct {
	_ struct{} `type:"structure"`

	// The AWS Support case ID requested or returned in the call. The case ID is
	// an alphanumeric string formatted as shown in this example: case-12345678910-2013-c4c1d2bf33c5cf47
	CaseId *string `locationName:"caseId" type:"string"`
}

// String returns the string representation
func (s ResolveCaseInput) String() string {
	return awsutil.Prettify(s)
}

// The status of the case returned by the ResolveCase operation.
type ResolveCaseOutput struct {
	_ struct{} `type:"structure"`

	// The status of the case after the ResolveCase request was processed.
	FinalCaseStatus *string `locationName:"finalCaseStatus" type:"string"`

	// The status of the case when the ResolveCase request was sent.
	InitialCaseStatus *string `locationName:"initialCaseStatus" type:"string"`
}

// String returns the string representation
func (s ResolveCaseOutput) String() string {
	return awsutil.Prettify(s)
}

const opResolveCase = "ResolveCase"

// ResolveCaseRequest returns a request value for making API operation for
// AWS Support.
//
// Resolves a support case. This operation takes a caseId and returns the initial
// and final state of the case.
//
//    * You must have a Business or Enterprise support plan to use the AWS Support
//    API.
//
//    * If you call the AWS Support API from an account that does not have a
//    Business or Enterprise support plan, the SubscriptionRequiredException
//    error message appears. For information about changing your support plan,
//    see AWS Support (http://aws.amazon.com/premiumsupport/).
//
//    // Example sending a request using ResolveCaseRequest.
//    req := client.ResolveCaseRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/ResolveCase
func (c *Client) ResolveCaseRequest(input *ResolveCaseInput) ResolveCaseRequest {
	op := &aws.Operation{
		Name:       opResolveCase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResolveCaseInput{}
	}

	req := c.newRequest(op, input, &ResolveCaseOutput{})

	return ResolveCaseRequest{Request: req, Input: input, Copy: c.ResolveCaseRequest}
}

// ResolveCaseRequest is the request type for the
// ResolveCase API operation.
type ResolveCaseRequest struct {
	*aws.Request
	Input *ResolveCaseInput
	Copy  func(*ResolveCaseInput) ResolveCaseRequest
}

// Send marshals and sends the ResolveCase API request.
func (r ResolveCaseRequest) Send(ctx context.Context) (*ResolveCaseResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ResolveCaseResponse{
		ResolveCaseOutput: r.Request.Data.(*ResolveCaseOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ResolveCaseResponse is the response type for the
// ResolveCase API operation.
type ResolveCaseResponse struct {
	*ResolveCaseOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ResolveCase request.
func (r *ResolveCaseResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
