// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package swf

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CountPendingDecisionTasksInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that contains the task list.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The name of the task list.
	//
	// TaskList is a required field
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`
}

// String returns the string representation
func (s CountPendingDecisionTasksInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CountPendingDecisionTasksInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CountPendingDecisionTasksInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 1))
	}

	if s.TaskList == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskList"))
	}
	if s.TaskList != nil {
		if err := s.TaskList.Validate(); err != nil {
			invalidParams.AddNested("TaskList", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the count of tasks in a task list.
type CountPendingDecisionTasksOutput struct {
	_ struct{} `type:"structure"`

	// The number of tasks in the task list.
	//
	// Count is a required field
	Count *int64 `locationName:"count" type:"integer" required:"true"`

	// If set to true, indicates that the actual count was more than the maximum
	// supported by this API and the count returned is the truncated value.
	Truncated *bool `locationName:"truncated" type:"boolean"`
}

// String returns the string representation
func (s CountPendingDecisionTasksOutput) String() string {
	return awsutil.Prettify(s)
}

const opCountPendingDecisionTasks = "CountPendingDecisionTasks"

// CountPendingDecisionTasksRequest returns a request value for making API operation for
// Amazon Simple Workflow Service.
//
// Returns the estimated number of decision tasks in the specified task list.
// The count returned is an approximation and isn't guaranteed to be exact.
// If you specify a task list that no decision task was ever scheduled in then
// 0 is returned.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the taskList.name parameter by using a Condition element with
//    the swf:taskList.name key to allow the action to access only certain task
//    lists.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
//    // Example sending a request using CountPendingDecisionTasksRequest.
//    req := client.CountPendingDecisionTasksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) CountPendingDecisionTasksRequest(input *CountPendingDecisionTasksInput) CountPendingDecisionTasksRequest {
	op := &aws.Operation{
		Name:       opCountPendingDecisionTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CountPendingDecisionTasksInput{}
	}

	req := c.newRequest(op, input, &CountPendingDecisionTasksOutput{})

	return CountPendingDecisionTasksRequest{Request: req, Input: input, Copy: c.CountPendingDecisionTasksRequest}
}

// CountPendingDecisionTasksRequest is the request type for the
// CountPendingDecisionTasks API operation.
type CountPendingDecisionTasksRequest struct {
	*aws.Request
	Input *CountPendingDecisionTasksInput
	Copy  func(*CountPendingDecisionTasksInput) CountPendingDecisionTasksRequest
}

// Send marshals and sends the CountPendingDecisionTasks API request.
func (r CountPendingDecisionTasksRequest) Send(ctx context.Context) (*CountPendingDecisionTasksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CountPendingDecisionTasksResponse{
		CountPendingDecisionTasksOutput: r.Request.Data.(*CountPendingDecisionTasksOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CountPendingDecisionTasksResponse is the response type for the
// CountPendingDecisionTasks API operation.
type CountPendingDecisionTasksResponse struct {
	*CountPendingDecisionTasksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CountPendingDecisionTasks request.
func (r *CountPendingDecisionTasksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
