// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package swf

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type RespondActivityTaskCompletedInput struct {
	_ struct{} `type:"structure"`

	// The result of the activity task. It is a free form string that is implementation
	// specific.
	Result *string `locationName:"result" type:"string"`

	// The taskToken of the ActivityTask.
	//
	// taskToken is generated by the service and should be treated as an opaque
	// value. If the task is passed to another process, its taskToken must also
	// be passed. This enables it to provide its progress and respond with results.
	//
	// TaskToken is a required field
	TaskToken *string `locationName:"taskToken" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RespondActivityTaskCompletedInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RespondActivityTaskCompletedInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RespondActivityTaskCompletedInput"}

	if s.TaskToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskToken"))
	}
	if s.TaskToken != nil && len(*s.TaskToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TaskToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RespondActivityTaskCompletedOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RespondActivityTaskCompletedOutput) String() string {
	return awsutil.Prettify(s)
}

const opRespondActivityTaskCompleted = "RespondActivityTaskCompleted"

// RespondActivityTaskCompletedRequest returns a request value for making API operation for
// Amazon Simple Workflow Service.
//
// Used by workers to tell the service that the ActivityTask identified by the
// taskToken completed successfully with a result (if provided). The result
// appears in the ActivityTaskCompleted event in the workflow history.
//
// If the requested task doesn't complete successfully, use RespondActivityTaskFailed
// instead. If the worker finds that the task is canceled through the canceled
// flag returned by RecordActivityTaskHeartbeat, it should cancel the task,
// clean up and then call RespondActivityTaskCanceled.
//
// A task is considered open from the time that it is scheduled until it is
// closed. Therefore a task is reported as open while a worker is processing
// it. A task is closed after it has been specified in a call to RespondActivityTaskCompleted,
// RespondActivityTaskCanceled, RespondActivityTaskFailed, or the task has timed
// out (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types).
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
//    // Example sending a request using RespondActivityTaskCompletedRequest.
//    req := client.RespondActivityTaskCompletedRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) RespondActivityTaskCompletedRequest(input *RespondActivityTaskCompletedInput) RespondActivityTaskCompletedRequest {
	op := &aws.Operation{
		Name:       opRespondActivityTaskCompleted,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RespondActivityTaskCompletedInput{}
	}

	req := c.newRequest(op, input, &RespondActivityTaskCompletedOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return RespondActivityTaskCompletedRequest{Request: req, Input: input, Copy: c.RespondActivityTaskCompletedRequest}
}

// RespondActivityTaskCompletedRequest is the request type for the
// RespondActivityTaskCompleted API operation.
type RespondActivityTaskCompletedRequest struct {
	*aws.Request
	Input *RespondActivityTaskCompletedInput
	Copy  func(*RespondActivityTaskCompletedInput) RespondActivityTaskCompletedRequest
}

// Send marshals and sends the RespondActivityTaskCompleted API request.
func (r RespondActivityTaskCompletedRequest) Send(ctx context.Context) (*RespondActivityTaskCompletedResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RespondActivityTaskCompletedResponse{
		RespondActivityTaskCompletedOutput: r.Request.Data.(*RespondActivityTaskCompletedOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RespondActivityTaskCompletedResponse is the response type for the
// RespondActivityTaskCompleted API operation.
type RespondActivityTaskCompletedResponse struct {
	*RespondActivityTaskCompletedOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RespondActivityTaskCompleted request.
func (r *RespondActivityTaskCompletedResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
