// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package swf

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type SignalWorkflowExecutionInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain containing the workflow execution to signal.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// Data to attach to the WorkflowExecutionSignaled event in the target workflow
	// execution's history.
	Input *string `locationName:"input" type:"string"`

	// The runId of the workflow execution to signal.
	RunId *string `locationName:"runId" type:"string"`

	// The name of the signal. This name must be meaningful to the target workflow.
	//
	// SignalName is a required field
	SignalName *string `locationName:"signalName" min:"1" type:"string" required:"true"`

	// The workflowId of the workflow execution to signal.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SignalWorkflowExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SignalWorkflowExecutionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SignalWorkflowExecutionInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 1))
	}

	if s.SignalName == nil {
		invalidParams.Add(aws.NewErrParamRequired("SignalName"))
	}
	if s.SignalName != nil && len(*s.SignalName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SignalName", 1))
	}

	if s.WorkflowId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SignalWorkflowExecutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SignalWorkflowExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

const opSignalWorkflowExecution = "SignalWorkflowExecution"

// SignalWorkflowExecutionRequest returns a request value for making API operation for
// Amazon Simple Workflow Service.
//
// Records a WorkflowExecutionSignaled event in the workflow execution history
// and creates a decision task for the workflow execution identified by the
// given domain, workflowId and runId. The event is recorded with the specified
// user defined signalName and input (if provided).
//
// If a runId isn't specified, then the WorkflowExecutionSignaled event is recorded
// in the history of the current open workflow with the matching workflowId
// in the domain.
//
// If the specified workflow execution isn't open, this method fails with UnknownResource.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
//    // Example sending a request using SignalWorkflowExecutionRequest.
//    req := client.SignalWorkflowExecutionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) SignalWorkflowExecutionRequest(input *SignalWorkflowExecutionInput) SignalWorkflowExecutionRequest {
	op := &aws.Operation{
		Name:       opSignalWorkflowExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SignalWorkflowExecutionInput{}
	}

	req := c.newRequest(op, input, &SignalWorkflowExecutionOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return SignalWorkflowExecutionRequest{Request: req, Input: input, Copy: c.SignalWorkflowExecutionRequest}
}

// SignalWorkflowExecutionRequest is the request type for the
// SignalWorkflowExecution API operation.
type SignalWorkflowExecutionRequest struct {
	*aws.Request
	Input *SignalWorkflowExecutionInput
	Copy  func(*SignalWorkflowExecutionInput) SignalWorkflowExecutionRequest
}

// Send marshals and sends the SignalWorkflowExecution API request.
func (r SignalWorkflowExecutionRequest) Send(ctx context.Context) (*SignalWorkflowExecutionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SignalWorkflowExecutionResponse{
		SignalWorkflowExecutionOutput: r.Request.Data.(*SignalWorkflowExecutionOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SignalWorkflowExecutionResponse is the response type for the
// SignalWorkflowExecution API operation.
type SignalWorkflowExecutionResponse struct {
	*SignalWorkflowExecutionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SignalWorkflowExecution request.
func (r *SignalWorkflowExecutionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
