// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package synthetics

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteCanaryInput struct {
	_ struct{} `type:"structure"`

	// The name of the canary that you want to delete. To find the names of your
	// canaries, use DescribeCanaries (https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html).
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCanaryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCanaryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteCanaryInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteCanaryInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteCanaryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCanaryOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteCanaryOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteCanary = "DeleteCanary"

// DeleteCanaryRequest returns a request value for making API operation for
// Synthetics.
//
// Permanently deletes the specified canary.
//
// When you delete a canary, resources used and created by the canary are not
// automatically deleted. After you delete a canary that you do not intend to
// use again, you should also delete the following:
//
//    * The Lambda functions and layers used by this canary. These have the
//    prefix cwsyn-MyCanaryName .
//
//    * The CloudWatch alarms created for this canary. These alarms have a name
//    of Synthetics-SharpDrop-Alarm-MyCanaryName .
//
//    * Amazon S3 objects and buckets, such as the canary's artifact location.
//
//    * IAM roles created for the canary. If they were created in the console,
//    these roles have the name role/service-role/CloudWatchSyntheticsRole-MyCanaryName .
//
//    * CloudWatch Logs log groups created for the canary. These logs groups
//    have the name /aws/lambda/cwsyn-MyCanaryName .
//
// Before you delete a canary, you might want to use GetCanary to display the
// information about this canary. Make note of the information returned by this
// operation so that you can delete these resources after you delete the canary.
//
//    // Example sending a request using DeleteCanaryRequest.
//    req := client.DeleteCanaryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/DeleteCanary
func (c *Client) DeleteCanaryRequest(input *DeleteCanaryInput) DeleteCanaryRequest {
	op := &aws.Operation{
		Name:       opDeleteCanary,
		HTTPMethod: "DELETE",
		HTTPPath:   "/canary/{name}",
	}

	if input == nil {
		input = &DeleteCanaryInput{}
	}

	req := c.newRequest(op, input, &DeleteCanaryOutput{})

	return DeleteCanaryRequest{Request: req, Input: input, Copy: c.DeleteCanaryRequest}
}

// DeleteCanaryRequest is the request type for the
// DeleteCanary API operation.
type DeleteCanaryRequest struct {
	*aws.Request
	Input *DeleteCanaryInput
	Copy  func(*DeleteCanaryInput) DeleteCanaryRequest
}

// Send marshals and sends the DeleteCanary API request.
func (r DeleteCanaryRequest) Send(ctx context.Context) (*DeleteCanaryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteCanaryResponse{
		DeleteCanaryOutput: r.Request.Data.(*DeleteCanaryOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteCanaryResponse is the response type for the
// DeleteCanary API operation.
type DeleteCanaryResponse struct {
	*DeleteCanaryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteCanary request.
func (r *DeleteCanaryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
