// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package synthetics

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeCanariesLastRunInput struct {
	_ struct{} `type:"structure"`

	// Specify this parameter to limit how many runs are returned each time you
	// use the DescribeLastRun operation. If you omit this parameter, the default
	// of 100 is used.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token that indicates that there is more data available. You can use this
	// token in a subsequent DescribeCanaries operation to retrieve the next set
	// of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeCanariesLastRunInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCanariesLastRunInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeCanariesLastRunInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeCanariesLastRunInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeCanariesLastRunOutput struct {
	_ struct{} `type:"structure"`

	// An array that contains the information from the most recent run of each canary.
	CanariesLastRun []CanaryLastRun `type:"list"`

	// A token that indicates that there is more data available. You can use this
	// token in a subsequent DescribeCanariesLastRun operation to retrieve the next
	// set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeCanariesLastRunOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeCanariesLastRunOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CanariesLastRun != nil {
		v := s.CanariesLastRun

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "CanariesLastRun", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDescribeCanariesLastRun = "DescribeCanariesLastRun"

// DescribeCanariesLastRunRequest returns a request value for making API operation for
// Synthetics.
//
// Use this operation to see information from the most recent run of each canary
// that you have created.
//
//    // Example sending a request using DescribeCanariesLastRunRequest.
//    req := client.DescribeCanariesLastRunRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/DescribeCanariesLastRun
func (c *Client) DescribeCanariesLastRunRequest(input *DescribeCanariesLastRunInput) DescribeCanariesLastRunRequest {
	op := &aws.Operation{
		Name:       opDescribeCanariesLastRun,
		HTTPMethod: "POST",
		HTTPPath:   "/canaries/last-run",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCanariesLastRunInput{}
	}

	req := c.newRequest(op, input, &DescribeCanariesLastRunOutput{})

	return DescribeCanariesLastRunRequest{Request: req, Input: input, Copy: c.DescribeCanariesLastRunRequest}
}

// DescribeCanariesLastRunRequest is the request type for the
// DescribeCanariesLastRun API operation.
type DescribeCanariesLastRunRequest struct {
	*aws.Request
	Input *DescribeCanariesLastRunInput
	Copy  func(*DescribeCanariesLastRunInput) DescribeCanariesLastRunRequest
}

// Send marshals and sends the DescribeCanariesLastRun API request.
func (r DescribeCanariesLastRunRequest) Send(ctx context.Context) (*DescribeCanariesLastRunResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeCanariesLastRunResponse{
		DescribeCanariesLastRunOutput: r.Request.Data.(*DescribeCanariesLastRunOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeCanariesLastRunRequestPaginator returns a paginator for DescribeCanariesLastRun.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeCanariesLastRunRequest(input)
//   p := synthetics.NewDescribeCanariesLastRunRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeCanariesLastRunPaginator(req DescribeCanariesLastRunRequest) DescribeCanariesLastRunPaginator {
	return DescribeCanariesLastRunPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeCanariesLastRunInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeCanariesLastRunPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeCanariesLastRunPaginator struct {
	aws.Pager
}

func (p *DescribeCanariesLastRunPaginator) CurrentPage() *DescribeCanariesLastRunOutput {
	return p.Pager.CurrentPage().(*DescribeCanariesLastRunOutput)
}

// DescribeCanariesLastRunResponse is the response type for the
// DescribeCanariesLastRun API operation.
type DescribeCanariesLastRunResponse struct {
	*DescribeCanariesLastRunOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeCanariesLastRun request.
func (r *DescribeCanariesLastRunResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
