// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package synthetics

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// This structure contains all information about one canary in your account.
type Canary struct {
	_ struct{} `type:"structure"`

	// The location in Amazon S3 where Synthetics stores artifacts from the runs
	// of this canary. Artifacts include the log file, screenshots, and HAR files.
	ArtifactS3Location *string `min:"1" type:"string"`

	// This structure contains information about the canary's Lambda handler and
	// where its code is stored by CloudWatch Synthetics.
	Code *CanaryCodeOutput `type:"structure"`

	// The ARN of the Lambda function that is used as your canary's engine. For
	// more information about Lambda ARN format, see Resources and Conditions for
	// Lambda Actions (https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html).
	EngineArn *string `type:"string"`

	// The ARN of the IAM role used to run the canary. This role must include lambda.amazonaws.com
	// as a principal in the trust policy.
	ExecutionRoleArn *string `type:"string"`

	// The number of days to retain data about failed runs of this canary.
	FailureRetentionPeriodInDays *int64 `min:"1" type:"integer"`

	// The unique ID of this canary.
	Id *string `type:"string"`

	// The name of the canary.
	Name *string `min:"1" type:"string"`

	// A structure that contains information for a canary run.
	RunConfig *CanaryRunConfigOutput `type:"structure"`

	// Specifies the runtime version to use for the canary. Currently, the only
	// valid value is syn-1.0. For more information about runtime versions, see
	// Canary Runtime Versions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).
	RuntimeVersion *string `min:"1" type:"string"`

	// A structure that contains information about how often the canary is to run,
	// and when these runs are to stop.
	Schedule *CanaryScheduleOutput `type:"structure"`

	// A structure that contains information about the canary's status.
	Status *CanaryStatus `type:"structure"`

	// The number of days to retain data about successful runs of this canary.
	SuccessRetentionPeriodInDays *int64 `min:"1" type:"integer"`

	// The list of key-value pairs that are associated with the canary.
	Tags map[string]string `min:"1" type:"map"`

	// A structure that contains information about when the canary was created,
	// modified, and most recently run.
	Timeline *CanaryTimeline `type:"structure"`

	// If this canary is to test an endpoint in a VPC, this structure contains information
	// about the subnets and security groups of the VPC endpoint. For more information,
	// see Running a Canary in a VPC (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html).
	VpcConfig *VpcConfigOutput `type:"structure"`
}

// String returns the string representation
func (s Canary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Canary) MarshalFields(e protocol.FieldEncoder) error {
	if s.ArtifactS3Location != nil {
		v := *s.ArtifactS3Location

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ArtifactS3Location", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Code != nil {
		v := s.Code

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Code", v, metadata)
	}
	if s.EngineArn != nil {
		v := *s.EngineArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EngineArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ExecutionRoleArn != nil {
		v := *s.ExecutionRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExecutionRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FailureRetentionPeriodInDays != nil {
		v := *s.FailureRetentionPeriodInDays

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FailureRetentionPeriodInDays", protocol.Int64Value(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RunConfig != nil {
		v := s.RunConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RunConfig", v, metadata)
	}
	if s.RuntimeVersion != nil {
		v := *s.RuntimeVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RuntimeVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Schedule != nil {
		v := s.Schedule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Schedule", v, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Status", v, metadata)
	}
	if s.SuccessRetentionPeriodInDays != nil {
		v := *s.SuccessRetentionPeriodInDays

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SuccessRetentionPeriodInDays", protocol.Int64Value(v), metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Timeline != nil {
		v := s.Timeline

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Timeline", v, metadata)
	}
	if s.VpcConfig != nil {
		v := s.VpcConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VpcConfig", v, metadata)
	}
	return nil
}

// Use this structure to input your script code for the canary. This structure
// contains the Lambda handler with the location where the canary should start
// running the script. If the script is stored in an S3 bucket, the bucket name,
// key, and version are also included. If the script was passed into the canary
// directly, the script code is contained in the value of Zipfile.
type CanaryCodeInput struct {
	_ struct{} `type:"structure"`

	// The entry point to use for the source code when running the canary. This
	// value must end with the string .handler.
	//
	// Handler is a required field
	Handler *string `min:"1" type:"string" required:"true"`

	// If your canary script is located in S3, specify the full bucket name here.
	// The bucket must already exist. Specify the full bucket name, including s3://
	// as the start of the bucket name.
	S3Bucket *string `min:"1" type:"string"`

	// The S3 key of your script. For more information, see Working with Amazon
	// S3 Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingObjects.html).
	S3Key *string `min:"1" type:"string"`

	// The S3 version ID of your script.
	S3Version *string `min:"1" type:"string"`

	// If you input your canary script directly into the canary instead of referring
	// to an S3 location, the value of this parameter is the .zip file that contains
	// the script. It can be up to 5 MB.
	//
	// ZipFile is automatically base64 encoded/decoded by the SDK.
	ZipFile []byte `min:"1" type:"blob"`
}

// String returns the string representation
func (s CanaryCodeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CanaryCodeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CanaryCodeInput"}

	if s.Handler == nil {
		invalidParams.Add(aws.NewErrParamRequired("Handler"))
	}
	if s.Handler != nil && len(*s.Handler) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Handler", 1))
	}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Bucket", 1))
	}
	if s.S3Key != nil && len(*s.S3Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Key", 1))
	}
	if s.S3Version != nil && len(*s.S3Version) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Version", 1))
	}
	if s.ZipFile != nil && len(s.ZipFile) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ZipFile", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CanaryCodeInput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Handler != nil {
		v := *s.Handler

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Handler", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Bucket != nil {
		v := *s.S3Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3Bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Key != nil {
		v := *s.S3Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Version != nil {
		v := *s.S3Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3Version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ZipFile != nil {
		v := s.ZipFile

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ZipFile", protocol.QuotedValue{ValueMarshaler: protocol.BytesValue(v)}, metadata)
	}
	return nil
}

// This structure contains information about the canary's Lambda handler and
// where its code is stored by CloudWatch Synthetics.
type CanaryCodeOutput struct {
	_ struct{} `type:"structure"`

	// The entry point to use for the source code when running the canary.
	Handler *string `min:"1" type:"string"`

	// The ARN of the Lambda layer where Synthetics stores the canary script code.
	SourceLocationArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CanaryCodeOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CanaryCodeOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Handler != nil {
		v := *s.Handler

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Handler", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceLocationArn != nil {
		v := *s.SourceLocationArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceLocationArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// This structure contains information about the most recent run of a single
// canary.
type CanaryLastRun struct {
	_ struct{} `type:"structure"`

	// The name of the canary.
	CanaryName *string `min:"1" type:"string"`

	// The results from this canary's most recent run.
	LastRun *CanaryRun `type:"structure"`
}

// String returns the string representation
func (s CanaryLastRun) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CanaryLastRun) MarshalFields(e protocol.FieldEncoder) error {
	if s.CanaryName != nil {
		v := *s.CanaryName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CanaryName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastRun != nil {
		v := s.LastRun

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LastRun", v, metadata)
	}
	return nil
}

// This structure contains the details about one run of one canary.
type CanaryRun struct {
	_ struct{} `type:"structure"`

	// The location where the canary stored artifacts from the run. Artifacts include
	// the log file, screenshots, and HAR files.
	ArtifactS3Location *string `min:"1" type:"string"`

	// The name of the canary.
	Name *string `min:"1" type:"string"`

	// The status of this run.
	Status *CanaryRunStatus `type:"structure"`

	// A structure that contains the start and end times of this run.
	Timeline *CanaryRunTimeline `type:"structure"`
}

// String returns the string representation
func (s CanaryRun) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CanaryRun) MarshalFields(e protocol.FieldEncoder) error {
	if s.ArtifactS3Location != nil {
		v := *s.ArtifactS3Location

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ArtifactS3Location", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Status", v, metadata)
	}
	if s.Timeline != nil {
		v := s.Timeline

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Timeline", v, metadata)
	}
	return nil
}

// A structure that contains input information for a canary run.
type CanaryRunConfigInput struct {
	_ struct{} `type:"structure"`

	// The maximum amount of memory available to the canary while it is running,
	// in MB. The value you specify must be a multiple of 64.
	MemoryInMB *int64 `min:"960" type:"integer"`

	// How long the canary is allowed to run before it must stop. If you omit this
	// field, the frequency of the canary is used as this value, up to a maximum
	// of 14 minutes.
	//
	// TimeoutInSeconds is a required field
	TimeoutInSeconds *int64 `min:"60" type:"integer" required:"true"`
}

// String returns the string representation
func (s CanaryRunConfigInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CanaryRunConfigInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CanaryRunConfigInput"}
	if s.MemoryInMB != nil && *s.MemoryInMB < 960 {
		invalidParams.Add(aws.NewErrParamMinValue("MemoryInMB", 960))
	}

	if s.TimeoutInSeconds == nil {
		invalidParams.Add(aws.NewErrParamRequired("TimeoutInSeconds"))
	}
	if s.TimeoutInSeconds != nil && *s.TimeoutInSeconds < 60 {
		invalidParams.Add(aws.NewErrParamMinValue("TimeoutInSeconds", 60))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CanaryRunConfigInput) MarshalFields(e protocol.FieldEncoder) error {
	if s.MemoryInMB != nil {
		v := *s.MemoryInMB

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MemoryInMB", protocol.Int64Value(v), metadata)
	}
	if s.TimeoutInSeconds != nil {
		v := *s.TimeoutInSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TimeoutInSeconds", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A structure that contains information for a canary run.
type CanaryRunConfigOutput struct {
	_ struct{} `type:"structure"`

	// The maximum amount of memory available to the canary while it is running,
	// in MB. The value you must be a multiple of 64.
	MemoryInMB *int64 `min:"960" type:"integer"`

	// How long the canary is allowed to run before it must stop.
	TimeoutInSeconds *int64 `min:"60" type:"integer"`
}

// String returns the string representation
func (s CanaryRunConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CanaryRunConfigOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.MemoryInMB != nil {
		v := *s.MemoryInMB

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MemoryInMB", protocol.Int64Value(v), metadata)
	}
	if s.TimeoutInSeconds != nil {
		v := *s.TimeoutInSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TimeoutInSeconds", protocol.Int64Value(v), metadata)
	}
	return nil
}

// This structure contains the status information about a canary run.
type CanaryRunStatus struct {
	_ struct{} `type:"structure"`

	// The current state of the run.
	State CanaryRunState `type:"string" enum:"true"`

	// If run of the canary failed, this field contains the reason for the error.
	StateReason *string `min:"1" type:"string"`

	// If this value is CANARY_FAILURE, an exception occurred in the canary code.
	// If this value is EXECUTION_FAILURE, an exception occurred in CloudWatch Synthetics.
	StateReasonCode CanaryRunStateReasonCode `type:"string" enum:"true"`
}

// String returns the string representation
func (s CanaryRunStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CanaryRunStatus) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StateReason != nil {
		v := *s.StateReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StateReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.StateReasonCode) > 0 {
		v := s.StateReasonCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StateReasonCode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// This structure contains the start and end times of a single canary run.
type CanaryRunTimeline struct {
	_ struct{} `type:"structure"`

	// The end time of the run.
	Completed *time.Time `type:"timestamp"`

	// The start time of the run.
	Started *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s CanaryRunTimeline) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CanaryRunTimeline) MarshalFields(e protocol.FieldEncoder) error {
	if s.Completed != nil {
		v := *s.Completed

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Completed",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Started != nil {
		v := *s.Started

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Started",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	return nil
}

// This structure specifies how often a canary is to make runs and the date
// and time when it should stop making runs.
type CanaryScheduleInput struct {
	_ struct{} `type:"structure"`

	// How long, in seconds, for the canary to continue making regular runs according
	// to the schedule in the Expression value. If you specify 0, the canary continues
	// making runs until you stop it. If you omit this field, the default of 0 is
	// used.
	DurationInSeconds *int64 `type:"long"`

	// A rate expression that defines how often the canary is to run. The syntax
	// is rate(number unit). unit can be minute, minutes, or hour.
	//
	// For example, rate(1 minute) runs the canary once a minute, rate(10 minutes)
	// runs it once every 10 minutes, and rate(1 hour) runs it once every hour.
	// You can specify a frequency between rate(1 minute) and rate(1 hour).
	//
	// Specifying rate(0 minute) or rate(0 hour) is a special value that causes
	// the canary to run only once when it is started.
	//
	// Expression is a required field
	Expression *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CanaryScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CanaryScheduleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CanaryScheduleInput"}

	if s.Expression == nil {
		invalidParams.Add(aws.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Expression", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CanaryScheduleInput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DurationInSeconds != nil {
		v := *s.DurationInSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DurationInSeconds", protocol.Int64Value(v), metadata)
	}
	if s.Expression != nil {
		v := *s.Expression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Expression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// How long, in seconds, for the canary to continue making regular runs according
// to the schedule in the Expression value.
type CanaryScheduleOutput struct {
	_ struct{} `type:"structure"`

	// How long, in seconds, for the canary to continue making regular runs after
	// it was created. The runs are performed according to the schedule in the Expression
	// value.
	DurationInSeconds *int64 `type:"long"`

	// A rate expression that defines how often the canary is to run. The syntax
	// is rate(number unit). unit can be minute, minutes, or hour.
	//
	// For example, rate(1 minute) runs the canary once a minute, rate(10 minutes)
	// runs it once every 10 minutes, and rate(1 hour) runs it once every hour.
	//
	// Specifying rate(0 minute) or rate(0 hour) is a special value that causes
	// the canary to run only once when it is started.
	Expression *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CanaryScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CanaryScheduleOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DurationInSeconds != nil {
		v := *s.DurationInSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DurationInSeconds", protocol.Int64Value(v), metadata)
	}
	if s.Expression != nil {
		v := *s.Expression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Expression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A structure that contains the current state of the canary.
type CanaryStatus struct {
	_ struct{} `type:"structure"`

	// The current state of the canary.
	State CanaryState `type:"string" enum:"true"`

	// If the canary has insufficient permissions to run, this field provides more
	// details.
	StateReason *string `min:"1" type:"string"`

	// If the canary cannot run or has failed, this field displays the reason.
	StateReasonCode CanaryStateReasonCode `type:"string" enum:"true"`
}

// String returns the string representation
func (s CanaryStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CanaryStatus) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StateReason != nil {
		v := *s.StateReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StateReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.StateReasonCode) > 0 {
		v := s.StateReasonCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StateReasonCode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// This structure contains information about when the canary was created and
// modified.
type CanaryTimeline struct {
	_ struct{} `type:"structure"`

	// The date and time the canary was created.
	Created *time.Time `type:"timestamp"`

	// The date and time the canary was most recently modified.
	LastModified *time.Time `type:"timestamp"`

	// The date and time that the canary's most recent run started.
	LastStarted *time.Time `type:"timestamp"`

	// The date and time that the canary's most recent run ended.
	LastStopped *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s CanaryTimeline) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CanaryTimeline) MarshalFields(e protocol.FieldEncoder) error {
	if s.Created != nil {
		v := *s.Created

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Created",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastStarted != nil {
		v := *s.LastStarted

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastStarted",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastStopped != nil {
		v := *s.LastStopped

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastStopped",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	return nil
}

// This structure contains information about one canary runtime version. For
// more information about runtime versions, see Canary Runtime Versions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).
type RuntimeVersion struct {
	_ struct{} `type:"structure"`

	// If this runtime version is deprecated, this value is the date of deprecation.
	DeprecationDate *time.Time `type:"timestamp"`

	// A description of the runtime version, created by Amazon.
	Description *string `min:"1" type:"string"`

	// The date that the runtime version was released.
	ReleaseDate *time.Time `type:"timestamp"`

	// The name of the runtime version. Currently, the only valid value is syn-1.0.
	//
	// Specifies the runtime version to use for the canary. Currently, the only
	// valid value is syn-1.0.
	VersionName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RuntimeVersion) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RuntimeVersion) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeprecationDate != nil {
		v := *s.DeprecationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeprecationDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ReleaseDate != nil {
		v := *s.ReleaseDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReleaseDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.VersionName != nil {
		v := *s.VersionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// If this canary is to test an endpoint in a VPC, this structure contains information
// about the subnets and security groups of the VPC endpoint. For more information,
// see Running a Canary in a VPC (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html).
type VpcConfigInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the security groups for this canary.
	SecurityGroupIds []string `type:"list"`

	// The IDs of the subnets where this canary is to run.
	SubnetIds []string `type:"list"`
}

// String returns the string representation
func (s VpcConfigInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VpcConfigInput) MarshalFields(e protocol.FieldEncoder) error {
	if s.SecurityGroupIds != nil {
		v := s.SecurityGroupIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SecurityGroupIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SubnetIds != nil {
		v := s.SubnetIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SubnetIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// If this canary is to test an endpoint in a VPC, this structure contains information
// about the subnets and security groups of the VPC endpoint. For more information,
// see Running a Canary in a VPC (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html).
type VpcConfigOutput struct {
	_ struct{} `type:"structure"`

	// The IDs of the security groups for this canary.
	SecurityGroupIds []string `type:"list"`

	// The IDs of the subnets where this canary is to run.
	SubnetIds []string `type:"list"`

	// The IDs of the VPC where this canary is to run.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s VpcConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VpcConfigOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.SecurityGroupIds != nil {
		v := s.SecurityGroupIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SecurityGroupIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SubnetIds != nil {
		v := s.SubnetIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SubnetIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.VpcId != nil {
		v := *s.VpcId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VpcId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
