// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transcribe

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateMedicalVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The language code used for the entries within your custom vocabulary. The
	// language code of your custom vocabulary must match the language code of your
	// transcription job. US English (en-US) is the only language code available
	// for Amazon Transcribe Medical.
	//
	// LanguageCode is a required field
	LanguageCode LanguageCode `type:"string" required:"true" enum:"true"`

	// The Amazon S3 location of the text file you use to define your custom vocabulary.
	// The URI must be in the same AWS region as the API endpoint you're calling.
	// Enter information about your VocabularyFileUri in the following format:
	//
	// https://s3.<aws-region>.amazonaws.com/<bucket-name>/<keyprefix>/<objectkey>
	//
	// This is an example of a vocabulary file uri location in Amazon S3:
	//
	// https://s3.us-east-1.amazonaws.com/AWSDOC-EXAMPLE-BUCKET/vocab.txt
	//
	// For more information about S3 object names, see Object Keys (http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys)
	// in the Amazon S3 Developer Guide.
	//
	// For more information about custom vocabularies, see Medical Custom Vocabularies
	// (http://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary-med).
	//
	// VocabularyFileUri is a required field
	VocabularyFileUri *string `min:"1" type:"string" required:"true"`

	// The name of the custom vocabulary. This case-sensitive name must be unique
	// within an AWS account. If you try to create a vocabulary with the same name
	// as a previous vocabulary you will receive a ConflictException error.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateMedicalVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMedicalVocabularyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateMedicalVocabularyInput"}
	if len(s.LanguageCode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("LanguageCode"))
	}

	if s.VocabularyFileUri == nil {
		invalidParams.Add(aws.NewErrParamRequired("VocabularyFileUri"))
	}
	if s.VocabularyFileUri != nil && len(*s.VocabularyFileUri) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VocabularyFileUri", 1))
	}

	if s.VocabularyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateMedicalVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// If the VocabularyState field is FAILED, this field contains information about
	// why the job failed.
	FailureReason *string `type:"string"`

	// The language code you chose to describe the entries in your custom vocabulary.
	// US English (en-US) is the only valid language code for Amazon Transcribe
	// Medical.
	LanguageCode LanguageCode `type:"string" enum:"true"`

	// The date and time you created the vocabulary.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the vocabulary. The name must be unique within an AWS account.
	// It is also case-sensitive.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of your custom vocabulary in Amazon Transcribe Medical.
	// If the state is READY you can use the vocabulary in a StartMedicalTranscriptionJob
	// request.
	VocabularyState VocabularyState `type:"string" enum:"true"`
}

// String returns the string representation
func (s CreateMedicalVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateMedicalVocabulary = "CreateMedicalVocabulary"

// CreateMedicalVocabularyRequest returns a request value for making API operation for
// Amazon Transcribe Service.
//
// Creates a new custom vocabulary that you can use to change how Amazon Transcribe
// Medical transcribes your audio file.
//
//    // Example sending a request using CreateMedicalVocabularyRequest.
//    req := client.CreateMedicalVocabularyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateMedicalVocabulary
func (c *Client) CreateMedicalVocabularyRequest(input *CreateMedicalVocabularyInput) CreateMedicalVocabularyRequest {
	op := &aws.Operation{
		Name:       opCreateMedicalVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateMedicalVocabularyInput{}
	}

	req := c.newRequest(op, input, &CreateMedicalVocabularyOutput{})

	return CreateMedicalVocabularyRequest{Request: req, Input: input, Copy: c.CreateMedicalVocabularyRequest}
}

// CreateMedicalVocabularyRequest is the request type for the
// CreateMedicalVocabulary API operation.
type CreateMedicalVocabularyRequest struct {
	*aws.Request
	Input *CreateMedicalVocabularyInput
	Copy  func(*CreateMedicalVocabularyInput) CreateMedicalVocabularyRequest
}

// Send marshals and sends the CreateMedicalVocabulary API request.
func (r CreateMedicalVocabularyRequest) Send(ctx context.Context) (*CreateMedicalVocabularyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateMedicalVocabularyResponse{
		CreateMedicalVocabularyOutput: r.Request.Data.(*CreateMedicalVocabularyOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateMedicalVocabularyResponse is the response type for the
// CreateMedicalVocabulary API operation.
type CreateMedicalVocabularyResponse struct {
	*CreateMedicalVocabularyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateMedicalVocabulary request.
func (r *CreateMedicalVocabularyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
