// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transcribe

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeleteMedicalTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// The name you provide to the DeleteMedicalTranscriptionJob object to delete
	// a transcription job.
	//
	// MedicalTranscriptionJobName is a required field
	MedicalTranscriptionJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMedicalTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMedicalTranscriptionJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteMedicalTranscriptionJobInput"}

	if s.MedicalTranscriptionJobName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MedicalTranscriptionJobName"))
	}
	if s.MedicalTranscriptionJobName != nil && len(*s.MedicalTranscriptionJobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MedicalTranscriptionJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteMedicalTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteMedicalTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteMedicalTranscriptionJob = "DeleteMedicalTranscriptionJob"

// DeleteMedicalTranscriptionJobRequest returns a request value for making API operation for
// Amazon Transcribe Service.
//
// Deletes a transcription job generated by Amazon Transcribe Medical and any
// related information.
//
//    // Example sending a request using DeleteMedicalTranscriptionJobRequest.
//    req := client.DeleteMedicalTranscriptionJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalTranscriptionJob
func (c *Client) DeleteMedicalTranscriptionJobRequest(input *DeleteMedicalTranscriptionJobInput) DeleteMedicalTranscriptionJobRequest {
	op := &aws.Operation{
		Name:       opDeleteMedicalTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMedicalTranscriptionJobInput{}
	}

	req := c.newRequest(op, input, &DeleteMedicalTranscriptionJobOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteMedicalTranscriptionJobRequest{Request: req, Input: input, Copy: c.DeleteMedicalTranscriptionJobRequest}
}

// DeleteMedicalTranscriptionJobRequest is the request type for the
// DeleteMedicalTranscriptionJob API operation.
type DeleteMedicalTranscriptionJobRequest struct {
	*aws.Request
	Input *DeleteMedicalTranscriptionJobInput
	Copy  func(*DeleteMedicalTranscriptionJobInput) DeleteMedicalTranscriptionJobRequest
}

// Send marshals and sends the DeleteMedicalTranscriptionJob API request.
func (r DeleteMedicalTranscriptionJobRequest) Send(ctx context.Context) (*DeleteMedicalTranscriptionJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteMedicalTranscriptionJobResponse{
		DeleteMedicalTranscriptionJobOutput: r.Request.Data.(*DeleteMedicalTranscriptionJobOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteMedicalTranscriptionJobResponse is the response type for the
// DeleteMedicalTranscriptionJob API operation.
type DeleteMedicalTranscriptionJobResponse struct {
	*DeleteMedicalTranscriptionJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteMedicalTranscriptionJob request.
func (r *DeleteMedicalTranscriptionJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
