// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transcribe

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeleteVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The name of the vocabulary to delete.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVocabularyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteVocabularyInput"}

	if s.VocabularyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteVocabularyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteVocabulary = "DeleteVocabulary"

// DeleteVocabularyRequest returns a request value for making API operation for
// Amazon Transcribe Service.
//
// Deletes a vocabulary from Amazon Transcribe.
//
//    // Example sending a request using DeleteVocabularyRequest.
//    req := client.DeleteVocabularyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabulary
func (c *Client) DeleteVocabularyRequest(input *DeleteVocabularyInput) DeleteVocabularyRequest {
	op := &aws.Operation{
		Name:       opDeleteVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVocabularyInput{}
	}

	req := c.newRequest(op, input, &DeleteVocabularyOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteVocabularyRequest{Request: req, Input: input, Copy: c.DeleteVocabularyRequest}
}

// DeleteVocabularyRequest is the request type for the
// DeleteVocabulary API operation.
type DeleteVocabularyRequest struct {
	*aws.Request
	Input *DeleteVocabularyInput
	Copy  func(*DeleteVocabularyInput) DeleteVocabularyRequest
}

// Send marshals and sends the DeleteVocabulary API request.
func (r DeleteVocabularyRequest) Send(ctx context.Context) (*DeleteVocabularyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteVocabularyResponse{
		DeleteVocabularyOutput: r.Request.Data.(*DeleteVocabularyOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteVocabularyResponse is the response type for the
// DeleteVocabulary API operation.
type DeleteVocabularyResponse struct {
	*DeleteVocabularyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteVocabulary request.
func (r *DeleteVocabularyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
